/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.ui.rules.FloatNumberRule;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWhitespaceDetector;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWordDetector;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWordRule;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class JavascriptCodeScanner
extends AbstractScriptScanner {
    private static String fgReturnKeyword = "return";
    private static String[] fgTokenProperties = new String[]{"DLTK_single_line_comment", "DLTK_default", "DLTK_keyword", "DLTK_keyword_return", "DLTK_number", "DLTK_function_definition"};

    public JavascriptCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = this.getToken("DLTK_keyword");
        Token keywordReturn = this.getToken("DLTK_keyword_return");
        Token comment = this.getToken("DLTK_single_line_comment");
        Token other = this.getToken("DLTK_default");
        Token def = this.getToken("DLTK_function_definition");
        Token number = this.getToken("DLTK_number");
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavascriptWhitespaceDetector()));
        JavascriptWordRule wordRule = new JavascriptWordRule(new JavascriptWordDetector(), (IToken)other, null, (IToken)def);
        int i = 0;
        while (i < JavaScriptKeywords.getJavaScriptKeywords().length) {
            wordRule.addWord(JavaScriptKeywords.getJavaScriptKeywords()[i], (IToken)keyword);
            ++i;
        }
        wordRule.addWord(fgReturnKeyword, (IToken)keywordReturn);
        rules.add(wordRule);
        rules.add(new FloatNumberRule((IToken)number));
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }
}

