/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.SwitchComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchStatement
extends Statement {
    private Keyword switchKeyword;
    private Expression condition;
    private final List<SwitchComponent> caseClauses = new ArrayList<SwitchComponent>();
    private int LP = -1;
    private int RP = -1;
    private int LC = -1;
    private int RC = -1;

    public SwitchStatement(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.switchKeyword != null) {
                this.switchKeyword.traverse(visitor);
            }
            if (this.condition != null) {
                this.condition.traverse(visitor);
            }
            if (this.caseClauses != null) {
                for (SwitchComponent comp : this.caseClauses) {
                    comp.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public List<SwitchComponent> getCaseClauses() {
        return this.caseClauses;
    }

    public void addCase(SwitchComponent component) {
        this.caseClauses.add(component);
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public int getLC() {
        return this.LC;
    }

    public void setLC(int LC) {
        this.LC = LC;
    }

    public int getRC() {
        return this.RC;
    }

    public void setRC(int RC) {
        this.RC = RC;
    }

    public Keyword getSwitchKeyword() {
        return this.switchKeyword;
    }

    public void setSwitchKeyword(Keyword keyword) {
        this.switchKeyword = keyword;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LC > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RC > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("switch");
        buffer.append(" (");
        buffer.append(this.condition.toSourceString(indentationString));
        buffer.append(")\n");
        buffer.append(indentationString);
        buffer.append("{\n");
        int i = 0;
        while (i < this.caseClauses.size()) {
            buffer.append(((ISourceable)this.caseClauses.get(i)).toSourceString(String.valueOf(indentationString) + "    "));
            ++i;
        }
        buffer.append(indentationString);
        buffer.append("}\n");
        return buffer.toString();
    }
}

