/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.preferences;

import java.net.URL;
import org.eclipse.dltk.javascript.formatter.preferences.Messages;
import org.eclipse.dltk.ui.formatter.FormatterModifyTabPage;
import org.eclipse.dltk.ui.formatter.IFormatterControlManager;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.preferences.FormatterMessages;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class JavaScriptIdentationTabPage
extends FormatterModifyTabPage {
    private Combo tabPolicy;
    private Text indentSize;
    private Text tabSize;
    private final String[] tabPolicyItems = new String[]{"space", "tab", "mixed"};
    private final String[] tabPolicyItemNames = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
    private TabPolicyListener tabPolicyListener;

    public JavaScriptIdentationTabPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group tabPolicyGroup = SWTFactory.createGroup((Composite)parent, (String)Messages.JavaScriptIdentationTabPage_GeneralSettingsGroup_name, (int)2, (int)1, (int)768);
        this.tabPolicy = manager.createCombo((Composite)tabPolicyGroup, (Object)"formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.tabPolicyItems, this.tabPolicyItemNames);
        this.tabPolicyListener = new TabPolicyListener(manager);
        this.tabPolicy.addSelectionListener((SelectionListener)this.tabPolicyListener);
        manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this.tabPolicyListener);
        this.indentSize = manager.createNumber((Composite)tabPolicyGroup, (Object)"formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size);
        this.tabSize = manager.createNumber((Composite)tabPolicyGroup, (Object)"formatter.tabulation.size", FormatterMessages.IndentationTabPage_general_group_option_tab_size);
        this.tabSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean tabMode;
                int index = JavaScriptIdentationTabPage.this.tabPolicy.getSelectionIndex();
                if (index >= 0 && (tabMode = "tab".equals(JavaScriptIdentationTabPage.this.tabPolicyItems[index]))) {
                    JavaScriptIdentationTabPage.this.indentSize.setText(JavaScriptIdentationTabPage.this.tabSize.getText());
                }
            }
        });
        Group indentGroup = SWTFactory.createGroup((Composite)parent, (String)Messages.JavaScriptIdentationTabPage_IndentGroup_name, (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)indentGroup, (Object)"formatter.indent.function", Messages.JavaScriptIdentationTabPage_StatementsWithinFunctionBody_name);
        manager.createCheckbox((Composite)indentGroup, (Object)"formatter.indent.blocks", Messages.JavaScriptIdentationTabPage_StatementsWithinBlocks_name);
        manager.createCheckbox((Composite)indentGroup, (Object)"formatter.indent.switch", Messages.JavaScriptIdentationTabPage_StatementsWithinSwitchBody_name);
        manager.createCheckbox((Composite)indentGroup, (Object)"formatter.indent.case", Messages.JavaScriptIdentationTabPage_StatementsWithinCaseBody_name);
        manager.createCheckbox((Composite)indentGroup, (Object)"formatter.indent.break", Messages.JavaScriptIdentationTabPage_BreakStatements_name);
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource("indentation-preview.js");
    }

    private class TabPolicyListener
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private final IFormatterControlManager manager;

        public TabPolicyListener(IFormatterControlManager manager) {
            this.manager = manager;
        }

        public void widgetSelected(SelectionEvent e) {
            int index = JavaScriptIdentationTabPage.this.tabPolicy.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(JavaScriptIdentationTabPage.this.tabPolicyItems[index]);
                this.manager.enableControl((Control)JavaScriptIdentationTabPage.this.indentSize, !tabMode);
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"formatter.tabulation.char"));
            this.manager.enableControl((Control)JavaScriptIdentationTabPage.this.indentSize, !tabMode);
        }
    }
}

