/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBlockWithBeginNode;

public class FormatterElseNode
extends FormatterBlockWithBeginNode {
    private boolean lineBreak;

    public FormatterElseNode(IFormatterDocument document, boolean lineBreak) {
        super(document);
        this.lineBreak = lineBreak;
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        if (this.isLineBreaking()) {
            visitor.writeLineBreak(context);
        } else {
            visitor.appendToPreviousLine(context, "");
            visitor.writeText(context, " ");
        }
        super.accept(context, visitor);
    }

    protected boolean isIndenting() {
        return false;
    }

    protected boolean isLineBreaking() {
        if (this.lineBreak) {
            return true;
        }
        return this.getDocument().getBoolean("formatter.newlines.else");
    }
}

