/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.LoopStatement;

public class WhileStatement
extends LoopStatement
implements ISemicolonStatement {
    private Keyword whileKeyword;
    private Expression condition;
    private int LP = -1;
    private int RP = -1;
    private int semi = -1;

    public WhileStatement(ASTNode parent) {
        super(parent);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Keyword getWhileKeyword() {
        return this.whileKeyword;
    }

    public void setWhileKeyword(Keyword keyword) {
        this.whileKeyword = keyword;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public int getSemicolonPosition() {
        return this.semi;
    }

    public void setSemicolonPosition(int semi) {
        this.semi = semi;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("while");
        buffer.append(" (");
        buffer.append(this.getCondition().toSourceString(indentationString));
        buffer.append(")");
        if (this.getBody() != null) {
            buffer.append("\n");
            buffer.append(this.getBody().toSourceString(indentationString));
        } else {
            buffer.append(";\n");
        }
        return buffer.toString();
    }
}

