/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.StatementBlock;

public class FunctionStatement
extends Expression {
    private Keyword functionKeyword;
    private Identifier name;
    private List arguments;
    private StatementBlock body;
    private int LP = -1;
    private int RP = -1;
    private List commas;

    public FunctionStatement(ASTNode parent) {
        super(parent);
    }

    public Keyword getFunctionKeyword() {
        return this.functionKeyword;
    }

    public void setFunctionKeyword(Keyword keyword) {
        this.functionKeyword = keyword;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public List getArguments() {
        return this.arguments;
    }

    public void setArguments(List arguments) {
        this.arguments = arguments;
    }

    public StatementBlock getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public List getArgumentCommas() {
        return this.commas;
    }

    public void setArgumentCommas(List commas) {
        this.commas = commas;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.arguments.size() == 0 || this.commas.size() == this.arguments.size() - 1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("function");
        buffer.append(" ");
        if (this.getName() != null) {
            buffer.append(this.getName().toSourceString(indentationString));
        }
        buffer.append(" (");
        int i = 0;
        while (i < this.getArguments().size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(((ISourceable)this.getArguments().get(i)).toSourceString(indentationString));
            ++i;
        }
        buffer.append(")\n");
        buffer.append(this.getBody().toSourceString(indentationString));
        return buffer.toString();
    }

    public boolean isBlock() {
        return true;
    }
}

