/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeArrayReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeBooleanReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeDateReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeJSObjectReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeNumberReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeStringReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeXMLReference;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.typeinfo.ITypeNames;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceModelLoader
implements ITypeNames {
    private static ReferenceModelLoader instance = null;
    private final Map<Type, List<IReference>> referencesByType = new IdentityHashMap<Type, List<IReference>>();
    private final Map<String, Factory> factories = new HashMap<String, Factory>();

    public static synchronized ReferenceModelLoader getInstance() {
        if (instance == null) {
            instance = new ReferenceModelLoader();
        }
        return instance;
    }

    private ReferenceModelLoader() {
        this.registerFactories();
    }

    public Collection<IReference> getChildren(String typeName) {
        Type type = TypeInfoModelLoader.getInstance().getType(typeName);
        if (type != null) {
            return this.getChildren(type);
        }
        return Collections.emptyList();
    }

    private Collection<IReference> getChildren(Type type) {
        List<IReference> list = this.referencesByType.get(type);
        if (list != null) {
            return list;
        }
        list = new ArrayList<IReference>();
        for (Member member : type.getMembers()) {
            if (member.getType() == null) {
                JavaScriptPlugin.error("No type for " + type.getName() + "." + member.getName());
                continue;
            }
            Factory factory = this.factories.get(member.getType().getName());
            if (factory == null) {
                JavaScriptPlugin.error("No factory for " + type.getName() + "." + member.getName() + ":" + member.getType().getName());
                continue;
            }
            StandardSelfCompletingReference reference = factory.create(member.getName());
            reference.setProposalInfo(member.getDescription());
            if (member instanceof Method) {
                Method method = (Method)member;
                if (!method.getParameters().isEmpty()) {
                    int paramCount = method.getParameters().size();
                    String[] params = new String[paramCount];
                    int i = 0;
                    while (i < paramCount) {
                        params[i] = ((Parameter)method.getParameters().get(i)).getName();
                        ++i;
                    }
                    reference.setParameterNames(params);
                }
                reference.setFunctionRef();
            }
            list.add(reference);
        }
        list = Collections.unmodifiableList(list);
        this.referencesByType.put(type, list);
        return list;
    }

    private void registerFactories() {
        this.factories.put("Array", new Factory(){

            public StandardSelfCompletingReference create(String name) {
                return new NativeArrayReference(name);
            }
        });
        this.factories.put("Boolean", new Factory(){

            public StandardSelfCompletingReference create(String name) {
                return new NativeBooleanReference(name);
            }
        });
        this.factories.put("Number", new Factory(){

            public StandardSelfCompletingReference create(String name) {
                return new NativeNumberReference(name);
            }
        });
        this.factories.put("String", new Factory(){

            public StandardSelfCompletingReference create(String name) {
                return new NativeStringReference(name);
            }
        });
        this.factories.put("XML", new Factory(){

            public StandardSelfCompletingReference create(String name) {
                return new NativeXMLReference(name);
            }
        });
        this.factories.put("Date", new Factory(){

            public StandardSelfCompletingReference create(String name) {
                return new NativeDateReference(name);
            }
        });
        this.factories.put("Object", new Factory(){

            public StandardSelfCompletingReference create(String name) {
                return new NativeJSObjectReference(name);
            }
        });
        this.factories.put("void", new Factory(){

            public StandardSelfCompletingReference create(String name) {
                return new StandardSelfCompletingReference(name, false);
            }
        });
    }

    private static interface Factory {
        public StandardSelfCompletingReference create(String var1);
    }
}

