/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import org.eclipse.dltk.internal.javascript.ti.ConstantValue;
import org.eclipse.dltk.internal.javascript.ti.IValueTypeFactory;
import org.eclipse.dltk.internal.javascript.ti.XMLListValue;
import org.eclipse.dltk.javascript.typeinference.IValueParent;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeNames;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

public class ValueTypeFactoryImpl
implements IValueTypeFactory,
ITypeNames {
    private final ITypeInfoContext context;

    ValueTypeFactoryImpl(ITypeInfoContext context) {
        this.context = context;
    }

    private IValueReference create(IValueParent parent, String typeName) {
        return this.create(parent, this.context.getTypeRef(typeName));
    }

    public IValueReference create(IValueParent parent, JSType type) {
        return new ConstantValue(type);
    }

    public IValueReference createObject(IValueParent parent) {
        return this.create(parent, "Object");
    }

    public IValueReference createArray(IValueParent parent) {
        return this.create(parent, "Array");
    }

    public IValueReference createBoolean(IValueParent parent) {
        return this.create(parent, "Boolean");
    }

    public IValueReference createNumber(IValueParent parent) {
        return this.create(parent, "Number");
    }

    public IValueReference createRegExp(IValueParent parent) {
        return this.create(parent, "RegExp");
    }

    public IValueReference createString(IValueParent parent) {
        return this.create(parent, "String");
    }

    public IValueReference createXML(IValueParent parent) {
        return this.create(parent, "XML");
    }

    public IValueReference createXMLList(IValueParent parent) {
        return new XMLListValue(parent, this.context);
    }
}

