/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import org.eclipse.dltk.internal.javascript.ti.AnonymousValue;
import org.eclipse.dltk.internal.javascript.ti.ValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;

public class FunctionValueCollection
extends ValueCollection {
    private final String functionName;
    private final IValueReference returnValue = new AnonymousValue();
    private final IValueReference thisValue;

    public FunctionValueCollection(IValueCollection parent, String functionName) {
        this(parent, functionName, new ThisValue());
    }

    public FunctionValueCollection(IValueCollection parent, String functionName, IValueReference thisValue) {
        super(parent);
        this.functionName = functionName;
        this.thisValue = thisValue;
        IValueReference arguments = this.createChild("arguments");
        arguments.setKind(ReferenceKind.LOCAL);
        IValueReference argumentsLength = arguments.getChild("length");
        argumentsLength.setDeclaredType(TypeUtil.ref("Number"));
        IValueReference argumentsArray = arguments.getChild("[]");
        argumentsArray.setDeclaredType(TypeUtil.ref("Object"));
    }

    public boolean isScope() {
        return true;
    }

    public IValueReference getReturnValue() {
        return this.returnValue;
    }

    public IValueReference getThis() {
        return this.thisValue;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "<" + this.functionName + ">";
    }

    protected static class ThisValue
    extends AnonymousValue {
        protected ThisValue() {
        }

        protected String getToStringPrefix() {
            return "this";
        }

        public boolean isReference() {
            return true;
        }
    }
}

