/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.parser.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

public class StructureRequestor
implements IStructureRequestor {
    private final ISourceElementRequestor requestor;

    public StructureRequestor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    public void acceptLocalReference(Identifier node, IValueReference reference) {
    }

    public void acceptArgumentDeclaration(Argument argument, ISourceModule sourceModule, JSType type) {
    }

    public void enterLocal(Identifier identifier, ISourceModule module, JSType type) {
    }

    public void exitLocal(int sourceEnd) {
    }

    public void acceptFieldReference(Identifier node, IValueReference reference) {
        this.requestor.acceptFieldReference(node.getName(), node.sourceStart() - 1);
    }

    public void acceptMethodReference(Identifier node, int argCount, IValueReference reference) {
        this.requestor.acceptMethodReference(node.getName(), argCount, node.sourceStart(), node.sourceEnd() - 1);
    }

    public void enterNamespace(String[] namespace) {
        this.requestor.enterModuleRoot();
        this.requestor.enterNamespace(namespace);
    }

    public void exitNamespace() {
        this.requestor.exitNamespace();
        this.requestor.exitModuleRoot();
    }

    public void enterType(IElementRequestor.TypeInfo typeInfo) {
        this.requestor.enterType(typeInfo);
    }

    public void exitType(int sourceEnd) {
        this.requestor.exitType(sourceEnd);
    }

    public void enterMethod(IElementRequestor.MethodInfo methodInfo, Expression identifier, IModelBuilder.IMethod method) {
        this.requestor.enterMethod(methodInfo);
    }

    public void exitMethod(int sourceEnd) {
        this.requestor.exitMethod(sourceEnd);
    }

    public void exitField(int sourceEnd) {
        this.requestor.exitField(sourceEnd);
    }

    public void enterField(IElementRequestor.FieldInfo fieldInfo, Expression identifer, JSType type) {
        this.requestor.enterField(fieldInfo);
    }

    public void updateField(IElementRequestor.FieldInfo fieldInfo, int flags) {
        this.requestor.updateField(fieldInfo, flags);
    }

    public boolean enterFieldCheckDuplicates(IElementRequestor.FieldInfo fieldInfo, Expression identifier, JSType type) {
        return this.requestor.enterFieldCheckDuplicates(fieldInfo);
    }
}

