/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.typeinfo.IElementConverter;
import org.eclipse.dltk.javascript.typeinfo.IElementResolver;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ITypeProvider;
import org.eclipse.dltk.utils.SimpleExtensionManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class TypeInfoManager {
    private static final String EXT_POINT = "org.eclipse.dltk.javascript.core.typeinfo";
    private static final String MODEL_ELEMENT = "model";
    private static final String RESOURCE_ATTR = "resource";
    private static final String URI_ATTR = "uri";
    private static final String BUILDER_ELEMENT = "builder";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final String RESOLVER_ELEMENT = "resolver";
    private static final String CONVERTER_ELEMENT = "converter";
    private static final SimpleExtensionManager<IModelBuilder> modelBuilderManager = new SimpleExtensionManager<IModelBuilder>(IModelBuilder.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected IModelBuilder createInstance(IConfigurationElement element) {
            if (TypeInfoManager.BUILDER_ELEMENT.equals(element.getName())) {
                return (IModelBuilder)super.createInstance(element);
            }
            return null;
        }
    };
    private static final SimpleExtensionManager<ITypeProvider> providerManager = new SimpleExtensionManager<ITypeProvider>(ITypeProvider.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected ITypeProvider createInstance(IConfigurationElement element) {
            if (TypeInfoManager.PROVIDER_ELEMENT.equals(element.getName())) {
                return (ITypeProvider)super.createInstance(element);
            }
            return null;
        }
    };
    private static final SimpleExtensionManager<IElementResolver> resolverManager = new SimpleExtensionManager<IElementResolver>(IElementResolver.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected IElementResolver createInstance(IConfigurationElement element) {
            if (TypeInfoManager.RESOLVER_ELEMENT.equals(element.getName())) {
                return (IElementResolver)super.createInstance(element);
            }
            return null;
        }
    };
    private static final SimpleExtensionManager<IElementConverter> converterManager = new SimpleExtensionManager<IElementConverter>(IElementConverter.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected IElementConverter createInstance(IConfigurationElement element) {
            if (TypeInfoManager.CONVERTER_ELEMENT.equals(element.getName())) {
                return (IElementConverter)super.createInstance(element);
            }
            return null;
        }
    };

    private static String trim(String str) {
        if (str != null && (str = str.trim()).length() == 0) {
            str = null;
        }
        return str;
    }

    private static URI createURI(IConfigurationElement element, String resource) {
        return URI.createPlatformPluginURI((String)("/" + element.getContributor().getName() + "/" + resource), (boolean)true);
    }

    private static IConfigurationElement[] getConfigurationElements() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_POINT);
    }

    public static IModelBuilder[] getModelBuilders() {
        return (IModelBuilder[])modelBuilderManager.getInstances();
    }

    public static ITypeProvider[] getTypeProviders() {
        return (ITypeProvider[])providerManager.getInstances();
    }

    public static IElementResolver[] getElementResolvers() {
        return (IElementResolver[])resolverManager.getInstances();
    }

    public static IElementConverter[] getElementConverters() {
        return (IElementConverter[])converterManager.getInstances();
    }

    public static ResourceSet loadModelResources() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IConfigurationElement[] iConfigurationElementArray = TypeInfoManager.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (MODEL_ELEMENT.equals(element.getName())) {
                String resource = TypeInfoManager.trim(element.getAttribute(RESOURCE_ATTR));
                String uri = TypeInfoManager.trim(element.getAttribute(URI_ATTR));
                try {
                    if (uri != null) {
                        if (resource != null) {
                            resourceSet.getURIConverter().getURIMap().put(URI.createURI((String)uri), TypeInfoManager.createURI(element, resource));
                            resourceSet.getResources().add((Object)new XMIResourceImpl(URI.createURI((String)uri)));
                        }
                    } else if (resource != null) {
                        resourceSet.getResources().add((Object)new XMIResourceImpl(TypeInfoManager.createURI(element, resource)));
                    }
                }
                catch (IllegalArgumentException e) {
                    JavaScriptPlugin.error(e);
                }
            }
            ++n2;
        }
        for (Resource r : new ArrayList(resourceSet.getResources())) {
            if (r.isLoaded()) continue;
            try {
                r.load(null);
            }
            catch (IOException e) {
                JavaScriptPlugin.error("Error loading " + r.getURI(), e);
                if (r.isLoaded()) continue;
                r.getContents().clear();
            }
        }
        return resourceSet;
    }
}

