/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.search.matching2.MatchingCollector;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValueCollection;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptMatchingVisitor
extends TypeInferencerVisitor {
    private final MatchingCollector<MatchingNode> locator;
    private final Map<ASTNode, VisitorMode> modes = new IdentityHashMap<ASTNode, VisitorMode>();
    private final Stack<ASTNode> visitStack = new Stack();

    public JavaScriptMatchingVisitor(ITypeInferenceContext context, MatchingCollector<MatchingNode> locator) {
        super(context);
        this.locator = locator;
    }

    public IValueReference visit(ASTNode node) {
        this.visitStack.push(node);
        try {
            IValueReference iValueReference = (IValueReference)super.visit(node);
            return iValueReference;
        }
        finally {
            this.visitStack.pop();
        }
    }

    private VisitorMode currentMode() {
        VisitorMode mode = this.modes.get(this.visitStack.peek());
        return mode != null ? mode : VisitorMode.NORMAL;
    }

    @Override
    public IValueReference visitCallExpression(CallExpression node) {
        ASTNode expression = node.getExpression();
        this.modes.put(expression, VisitorMode.CALL);
        IValueReference reference = this.visit(expression);
        this.modes.remove(expression);
        for (ASTNode argument : node.getArguments()) {
            this.visit(argument);
        }
        if (reference != null) {
            return reference.getChild("()");
        }
        return null;
    }

    @Override
    public IValueReference visitIdentifier(Identifier node) {
        IValueReference result = this.peekContext().getChild(node.getName());
        if (this.currentMode() == VisitorMode.CALL) {
            this.locator.report((Object)new MethodReferenceNode(node));
        } else {
            this.locator.report((Object)new FieldReferenceNode(node));
        }
        return result;
    }

    @Override
    public IValueReference visitPropertyExpression(PropertyExpression node) {
        IValueReference object = this.visit((ASTNode)node.getObject());
        Expression property = node.getProperty();
        if (property instanceof Identifier) {
            Identifier prop = (Identifier)property;
            if (this.currentMode() == VisitorMode.CALL) {
                this.locator.report((Object)new MethodReferenceNode(prop));
            } else {
                this.locator.report((Object)new FieldReferenceNode(prop));
            }
        }
        return this.extractNamedChild(object, property);
    }

    @Override
    protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
        IValueReference result = super.createVariable(context, declaration);
        this.locator.report((Object)new FieldDeclarationNode(declaration.getIdentifier(), result.getDeclaredType()));
        return result;
    }

    @Override
    public IValueReference visitFunctionStatement(FunctionStatement node) {
        IValueReference result = super.visitFunctionStatement(node);
        Identifier name = node.getName();
        if (name != null) {
            JSMethod method = (JSMethod)result.getAttribute("PARAMETERS");
            this.locator.report((Object)new MethodDeclarationNode(name, method));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VisitorMode {
        NORMAL,
        CALL;

    }
}

