/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldPredicate
extends AbstractMatchingPredicate<MatchingNode> {
    private final boolean declarations;
    private final boolean references;

    public FieldPredicate(FieldPattern pattern) {
        super((SearchPattern)pattern, pattern.name);
        this.declarations = pattern.findDeclarations;
        this.references = pattern.findReferences;
    }

    public MatchLevel match(MatchingNode node) {
        if (node instanceof FieldDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            FieldDeclarationNode fieldNode = (FieldDeclarationNode)node;
            return this.matchName(((Identifier)fieldNode.node).getName());
        }
        if (node instanceof FieldReferenceNode) {
            if (!this.references) {
                return null;
            }
            FieldReferenceNode fieldNode = (FieldReferenceNode)node;
            return this.matchName(((Identifier)fieldNode.node).getName());
        }
        return null;
    }
}

