/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeArrayReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeBooleanReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeDateReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeNumberReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeStringReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeXMLReference;
import org.eclipse.dltk.internal.javascript.typeinference.ScriptableScopeReference;
import org.eclipse.dltk.internal.javascript.typeinference.UnknownReference;
import org.eclipse.dltk.javascript.typeinference.IScriptableTypeProvider;
import org.mozilla.javascript.Scriptable;

public class ReferenceFactory {
    private static IScriptableTypeProvider[] providers;

    static {
        ReferenceFactory.initProviders();
    }

    private static void initProviders() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.javascript.core.customtype");
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Object> providerList = new ArrayList<Object>();
        int a = 0;
        while (a < extensions.length) {
            IConfigurationElement[] configurationElements = extensions[a].getConfigurationElements();
            int b = 0;
            while (b < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[b];
                try {
                    Object createExecutableExtension = configurationElement.createExecutableExtension("class");
                    if (createExecutableExtension instanceof IScriptableTypeProvider) {
                        providerList.add(createExecutableExtension);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++b;
            }
            ++a;
        }
        IScriptableTypeProvider[] pr = new IScriptableTypeProvider[providerList.size()];
        providerList.toArray(pr);
        providers = pr;
    }

    public static UnknownReference createNumberReference(String name) {
        return new NativeNumberReference(name);
    }

    public static UnknownReference createStringReference(String name) {
        return new NativeStringReference(name);
    }

    public static UnknownReference createBooleanReference(String name) {
        return new NativeBooleanReference(name);
    }

    public static UnknownReference createArrayReference(String name) {
        return new NativeArrayReference(name);
    }

    public static UnknownReference createDateReference(String name) {
        return new NativeDateReference(name);
    }

    public static UnknownReference createXMLReference(String name) {
        return new NativeXMLReference(name);
    }

    public static IReference createTypeReference(String paramOrVarName, String type, ReferenceResolverContext rrc) {
        if (type != null) {
            String typeLowerCase = type.toLowerCase();
            if ("boolean".equals(typeLowerCase)) {
                return ReferenceFactory.createBooleanReference(paramOrVarName);
            }
            if ("number".equals(typeLowerCase)) {
                return ReferenceFactory.createNumberReference(paramOrVarName);
            }
            if ("string".equals(typeLowerCase)) {
                return ReferenceFactory.createStringReference(paramOrVarName);
            }
            if ("date".equals(typeLowerCase)) {
                return ReferenceFactory.createDateReference(paramOrVarName);
            }
            if ("array".equals(typeLowerCase)) {
                return ReferenceFactory.createArrayReference(paramOrVarName);
            }
            if ("xml".equals(typeLowerCase)) {
                return ReferenceFactory.createXMLReference(paramOrVarName);
            }
            if (providers != null) {
                int i = 0;
                while (i < providers.length) {
                    IScriptableTypeProvider element = providers[i];
                    Scriptable ref = element.getType(paramOrVarName, type);
                    if (ref != null) {
                        return new ScriptableScopeReference(paramOrVarName, ref, rrc);
                    }
                    ++i;
                }
            }
        }
        return new UnknownReference(paramOrVarName, false);
    }
}

