/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclClass;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.ITclMixinElement;

public class IncrTclResolver {
    public static IMethod resolveSuperMethod(IMethod method) {
        block9: {
            IModelElement parent;
            block8: {
                parent = method.getParent();
                if (parent.getElementType() == 7) break block8;
                return null;
            }
            try {
                IType parentType = (IType)parent;
                ArrayList supersToHandle = new ArrayList();
                IncrTclResolver.fillSupers(parentType, supersToHandle);
                while (!supersToHandle.isEmpty()) {
                    String superClass = (String)supersToHandle.get(0);
                    supersToHandle.remove(0);
                    String memberkey = String.valueOf(TclParseUtil.getFQNFromModelElement((IModelElement)parent.getParent(), (String)IMixinRequestor.MIXIN_NAME_SEPARATOR)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + TclParseUtil.tclNameTo((String)superClass, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR);
                    if (memberkey.startsWith(IMixinRequestor.MIXIN_NAME_SEPARATOR)) {
                        memberkey = memberkey.substring(IMixinRequestor.MIXIN_NAME_SEPARATOR.length());
                    }
                    String[] split = superClass.split("::");
                    IModelElement[] types = IncrTclResolver.findTypeMixin(memberkey, split[split.length - 1], method.getScriptProject());
                    int j = 0;
                    while (j < types.length) {
                        IType type = (IType)types[j];
                        IMethod[] methods = type.getMethods();
                        int i = 0;
                        while (i < methods.length) {
                            if (methods[i].getElementName().equals(method.getElementName())) {
                                return methods[i];
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void fillSupers(IType parentType, List supers) {
        try {
            String[] superClasses = parentType.getSuperClasses();
            if (superClasses != null) {
                int i = 0;
                while (i < superClasses.length) {
                    supers.add(superClasses[i]);
                    ++i;
                }
            }
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return;
        }
    }

    public static ModuleDeclaration parseModule(IModelElement method) {
        ISourceModule sourceModule = (ISourceModule)method.getAncestor(5);
        ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        return module;
    }

    public static IModelElement[] findTypeMixin(String pattern, String name, IScriptProject project) {
        IMixinElement[] find = TclMixinModel.getInstance().getMixin(project).find(String.valueOf(pattern) + "*");
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
        int i = 0;
        while (i < find.length) {
            Object[] allObjects = find[i].getAllObjects();
            int j = 0;
            while (j < allObjects.length) {
                if (allObjects[j] != null && allObjects[j] instanceof IncrTclClass) {
                    String name2 = null;
                    if (allObjects[j] instanceof IncrTclClass) {
                        IncrTclClass field = (IncrTclClass)allObjects[j];
                        name2 = field.getName();
                    }
                    if (name2 != null && name.equals(name2)) {
                        elements.add(((ITclMixinElement)allObjects[j]).getModelElement());
                    }
                }
                ++j;
            }
            ++i;
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }
}

