/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.dltk.debug.ui.launchConfigurations.IMainLaunchConfigurationTabListener;
import org.eclipse.dltk.debug.ui.launchConfigurations.IMainLaunchConfigurationTabListenerManager;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpreterDescriptor;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class AbstractInterpreterComboBlock {
    public static final String PROPERTY_INTERPRETER = "PROPERTY_INTERPRETER";
    private IEnvironment environment;
    private Composite fControl;
    private List fInterpreters = new ArrayList();
    private Combo fCombo;
    private Button fManageButton;
    private ListenerList fListeners = new ListenerList();
    private InterpreterDescriptor fDefaultDescriptor = null;
    private InterpreterDescriptor fSpecificDescriptor = null;
    private Button fDefaultButton = null;
    private Button fSpecificButton = null;
    private String fTitle = null;
    private IStatus fStatus = OK_STATUS;
    private static IStatus OK_STATUS = new Status(0, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, "", null);

    protected AbstractInterpreterComboBlock(IMainLaunchConfigurationTabListenerManager listenerManager) {
        if (listenerManager != null) {
            listenerManager.addListener(new IMainLaunchConfigurationTabListener(){

                public void projectChanged(IProject project) {
                    IEnvironment env = EnvironmentManager.getEnvironment((IProject)project);
                    if (env != null && !env.equals(AbstractInterpreterComboBlock.this.environment)) {
                        AbstractInterpreterComboBlock.this.environment = env;
                        AbstractInterpreterComboBlock.this.refreshInterpreters();
                    }
                }

                public void interactiveChanged(boolean state) {
                }
            });
        }
    }

    protected AbstractInterpreterComboBlock() {
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void firePropertyChange() {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_INTERPRETER, null, (Object)this.getInterpreterPath());
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    public void createControl(Composite ancestor) {
        GridData data;
        Font font = ancestor.getFont();
        Composite comp = new Composite(ancestor, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fControl = comp;
        comp.setFont(font);
        Group group = new Group(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        if (this.fTitle == null) {
            this.fTitle = InterpretersMessages.InterpretersComboBlock_3;
        }
        group.setText(this.fTitle);
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton = new Button((Composite)group, 16);
            this.fDefaultButton.setText(this.fDefaultDescriptor.getDescription());
            this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AbstractInterpreterComboBlock.this.fDefaultButton.getSelection()) {
                        AbstractInterpreterComboBlock.this.setUseDefaultInterpreter();
                        if (AbstractInterpreterComboBlock.this.fInterpreters.isEmpty()) {
                            AbstractInterpreterComboBlock.this.setStatus((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 167, InterpretersMessages.InterpretersComboBlock_0, null));
                        } else {
                            AbstractInterpreterComboBlock.this.setStatus(OK_STATUS);
                        }
                        AbstractInterpreterComboBlock.this.firePropertyChange();
                    }
                }
            });
            data = new GridData();
            data.horizontalSpan = 3;
            this.fDefaultButton.setLayoutData((Object)data);
            this.fDefaultButton.setFont(font);
        }
        this.fSpecificButton = new Button((Composite)group, 16);
        if (this.fSpecificDescriptor != null) {
            this.fSpecificButton.setText(this.fSpecificDescriptor.getDescription());
        } else {
            this.fSpecificButton.setText(InterpretersMessages.InterpretersComboBlock_1);
        }
        this.fSpecificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractInterpreterComboBlock.this.fSpecificButton.getSelection()) {
                    AbstractInterpreterComboBlock.this.fCombo.setEnabled(true);
                    if (AbstractInterpreterComboBlock.this.fCombo.getText().length() == 0 && !AbstractInterpreterComboBlock.this.fInterpreters.isEmpty()) {
                        AbstractInterpreterComboBlock.this.fCombo.select(0);
                    }
                    if (AbstractInterpreterComboBlock.this.fInterpreters.isEmpty()) {
                        AbstractInterpreterComboBlock.this.setStatus((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 167, InterpretersMessages.InterpretersComboBlock_0, null));
                    } else {
                        AbstractInterpreterComboBlock.this.setStatus(OK_STATUS);
                    }
                    AbstractInterpreterComboBlock.this.firePropertyChange();
                }
            }
        });
        this.fSpecificButton.setFont(font);
        data = new GridData(1);
        this.fSpecificButton.setLayoutData((Object)data);
        this.fCombo = new Combo((Composite)group, 12);
        this.fCombo.setFont(font);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.fCombo.setLayoutData((Object)data);
        ControlAccessibleListener.addListener((Control)this.fCombo, this.fSpecificButton.getText());
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractInterpreterComboBlock.this.firePropertyChange();
            }
        });
        this.fManageButton = this.createPushButton((Composite)group, InterpretersMessages.InterpretersComboBlock_2);
        this.fManageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractInterpreterComboBlock.this.showInterpreterPreferencePage();
            }
        });
        this.fillWithWorkspaceInterpreters();
        if (this.fInterpreters.isEmpty()) {
            this.setStatus((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 167, InterpretersMessages.InterpretersComboBlock_0, null));
        } else {
            this.setStatus(OK_STATUS);
        }
    }

    protected void showPrefPage(String pageId) {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)pageId, (String[])new String[]{pageId}, null).open();
        this.refreshInterpreters();
    }

    private void restoreCombo(List elements, Object element, Combo combo) {
        int index = -1;
        if (element != null) {
            index = elements.indexOf(element);
        }
        if (index >= 0) {
            combo.select(index);
        } else {
            combo.select(0);
        }
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTUtil.createPushButton((Composite)parent, (String)label, null);
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setInterpreters(List interpreters) {
        this.fInterpreters.clear();
        Iterator iterator = interpreters.iterator();
        while (iterator.hasNext()) {
            IInterpreterInstall install = (IInterpreterInstall)iterator.next();
            if (this.environment == null || !this.environment.equals(install.getEnvironment())) continue;
            this.fInterpreters.add(install);
        }
        Collections.sort(this.fInterpreters, new Comparator(){

            public int compare(Object o1, Object o2) {
                IInterpreterInstall left = (IInterpreterInstall)o1;
                IInterpreterInstall right = (IInterpreterInstall)o2;
                return left.getName().compareToIgnoreCase(right.getName());
            }
        });
        String[] names = new String[this.fInterpreters.size()];
        Iterator iter = this.fInterpreters.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)iter.next();
            names[i] = Interpreter.getName();
            ++i;
        }
        this.fCombo.setItems(names);
        this.fCombo.setVisibleItemCount(Math.min(names.length, 20));
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    private void selectInterpreter(IInterpreterInstall Interpreter) {
        this.fSpecificButton.setSelection(true);
        this.fDefaultButton.setSelection(false);
        this.fCombo.setEnabled(true);
        int index = this.fInterpreters.indexOf(Interpreter);
        if (index >= 0) {
            this.fCombo.select(index);
        }
        this.firePropertyChange();
    }

    public IInterpreterInstall getInterpreter() {
        if (this.isDefaultInterpreter()) {
            return this.fDefaultDescriptor.getInterpreter();
        }
        int index = this.fCombo.getSelectionIndex();
        if (index >= 0) {
            return (IInterpreterInstall)this.fInterpreters.get(index);
        }
        return null;
    }

    public void setDefaultInterpreterDescriptor(InterpreterDescriptor descriptor) {
        this.fDefaultDescriptor = descriptor;
        this.setButtonTextFromDescriptor(this.fDefaultButton, descriptor);
    }

    private void setButtonTextFromDescriptor(Button button, InterpreterDescriptor descriptor) {
        if (button != null) {
            String currentText = button.getText();
            String newText = descriptor.getDescription();
            if (!newText.equals(currentText)) {
                button.setText(newText);
                this.fControl.layout();
            }
        }
    }

    public void setSpecificInterpreterDescriptor(InterpreterDescriptor descriptor) {
        this.fSpecificDescriptor = descriptor;
        this.setButtonTextFromDescriptor(this.fSpecificButton, descriptor);
    }

    public boolean isDefaultInterpreter() {
        if (this.fDefaultButton != null) {
            return this.fDefaultButton.getSelection();
        }
        return false;
    }

    public void setUseDefaultInterpreter() {
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton.setSelection(true);
            this.fSpecificButton.setSelection(false);
            this.fCombo.setEnabled(false);
            this.firePropertyChange();
        }
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void refresh() {
        this.setDefaultInterpreterDescriptor(this.fDefaultDescriptor);
    }

    public void refreshInterpreters() {
        IInterpreterInstall prevInterpreter = this.getInterpreter();
        this.fillWithWorkspaceInterpreters();
        if (this.fInterpreters.isEmpty()) {
            this.setStatus((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 167, InterpretersMessages.InterpretersComboBlock_0, null));
        } else {
            this.setStatus(OK_STATUS);
        }
        this.restoreCombo(this.fInterpreters, prevInterpreter, this.fCombo);
        this.setDefaultInterpreterDescriptor(this.fDefaultDescriptor);
        if (this.isDefaultInterpreter()) {
            this.setUseDefaultInterpreter();
        }
        this.setPath(this.getInterpreterPath());
        this.firePropertyChange();
    }

    public IPath getInterpreterPath() {
        if (this.fSpecificButton.getSelection()) {
            int index = this.fCombo.getSelectionIndex();
            if (index >= 0) {
                IInterpreterInstall Interpreter = (IInterpreterInstall)this.fInterpreters.get(index);
                return ScriptRuntime.newInterpreterContainerPath((IInterpreterInstall)Interpreter);
            }
            return null;
        }
        return ScriptRuntime.newDefaultInterpreterContainerPath();
    }

    public IBuildpathEntry getEntry() {
        return DLTKCore.newContainerEntry((IPath)this.getInterpreterPath());
    }

    public void setPath(IPath containerPath) {
        if (this.fInterpreters.isEmpty()) {
            this.setStatus((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 167, InterpretersMessages.InterpretersComboBlock_0, null));
        } else {
            this.setStatus(OK_STATUS);
        }
        if (ScriptRuntime.newDefaultInterpreterContainerPath().equals((Object)containerPath)) {
            this.setUseDefaultInterpreter();
        } else if (this.environment != null) {
            IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((String)this.getCurrentLanguageNature(), (String)this.environment.getId(), (IPath)containerPath);
            if (install == null) {
                this.setError(InterpretersMessages.InterpretersComboBlock_8);
            } else {
                this.selectInterpreter(install);
                IFileHandle location = install.getInstallLocation();
                if (location == null) {
                    this.setError(InterpretersMessages.InterpretersComboBlock_12);
                } else if (!location.exists()) {
                    this.setError(InterpretersMessages.InterpretersComboBlock_13);
                }
            }
        } else {
            this.setError(InterpretersMessages.InterpretersComboBlock_8);
        }
    }

    public void setEnvironment(IEnvironment environment) {
        this.environment = environment;
    }

    private void setError(String message) {
        this.setStatus((IStatus)new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, message, null));
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    private void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected abstract void showInterpreterPreferencePage();

    protected void fillWithWorkspaceInterpreters() {
        ArrayList<InterpreterStandin> standins = new ArrayList<InterpreterStandin>();
        IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)this.getCurrentLanguageNature());
        int i = 0;
        while (i < types.length) {
            IInterpreterInstallType type = types[i];
            IInterpreterInstall[] installs = type.getInterpreterInstalls();
            int j = 0;
            while (j < installs.length) {
                IInterpreterInstall install = installs[j];
                standins.add(new InterpreterStandin(install));
                ++j;
            }
            ++i;
        }
        this.setInterpreters(standins);
    }

    protected abstract String getCurrentLanguageNature();
}

