/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.SimpleLookupTable;
import org.eclipse.dltk.internal.core.builder.ScriptBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    String scriptProjectName;
    int buildNumber;
    long lastStructuralBuildTime;
    SimpleLookupTable structuralBuildTimes;
    public static final byte VERSION = 22;
    Set<IPath> externalFolderLocations = new HashSet<IPath>();
    boolean noCleanExternalFolders = false;
    static final byte SOURCE_FOLDER = 1;
    static final byte BINARY_FOLDER = 2;
    static final byte EXTERNAL_JAR = 3;
    static final byte INTERNAL_JAR = 4;

    private State() {
    }

    public State(IProject project) {
        this.scriptProjectName = project.getName();
        this.buildNumber = 0;
        this.lastStructuralBuildTime = System.currentTimeMillis();
        this.structuralBuildTimes = new SimpleLookupTable(3);
        this.noCleanExternalFolders = false;
    }

    protected State(ScriptBuilder scriptBuilder) {
        this.scriptProjectName = scriptBuilder.currentProject.getName();
        this.buildNumber = 0;
        this.lastStructuralBuildTime = System.currentTimeMillis();
        this.structuralBuildTimes = new SimpleLookupTable(3);
        this.noCleanExternalFolders = false;
    }

    void copyFrom(State lastState) {
        this.buildNumber = lastState.buildNumber + 1;
        this.lastStructuralBuildTime = lastState.lastStructuralBuildTime;
        this.structuralBuildTimes = lastState.structuralBuildTimes;
        this.externalFolderLocations.addAll(lastState.externalFolderLocations);
        this.noCleanExternalFolders = false;
    }

    public Set<IPath> getExternalFolders() {
        return this.externalFolderLocations;
    }

    static State read(IProject project, DataInputStream in) throws IOException {
        if (ScriptBuilder.DEBUG) {
            System.out.println("About to read state " + project.getName());
        }
        if (22 != in.readByte()) {
            if (ScriptBuilder.DEBUG) {
                System.out.println("Found non-compatible state version... answered null for " + project.getName());
            }
            return null;
        }
        State newState = new State();
        newState.scriptProjectName = in.readUTF();
        if (!project.getName().equals(newState.scriptProjectName)) {
            if (ScriptBuilder.DEBUG) {
                System.out.println("Project's name does not match... answered null");
            }
            return null;
        }
        newState.buildNumber = in.readInt();
        newState.lastStructuralBuildTime = in.readLong();
        int length = in.readInt();
        newState.externalFolderLocations.clear();
        int i = 0;
        while (i < length) {
            String folderName = in.readUTF();
            if (folderName.length() > 0) {
                newState.externalFolderLocations.add(Path.fromPortableString((String)folderName));
            }
            ++i;
        }
        newState.noCleanExternalFolders = in.readBoolean();
        if (ScriptBuilder.DEBUG) {
            System.out.println("Successfully read state for " + newState.scriptProjectName);
        }
        return newState;
    }

    void tagAsNoopBuild() {
        this.buildNumber = -1;
    }

    boolean wasNoopBuild() {
        return this.buildNumber == -1;
    }

    boolean wasStructurallyChanged(IProject prereqProject, State prereqState) {
        if (prereqState != null) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqProject.getName());
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.lastStructuralBuildTime) {
                return false;
            }
        }
        return true;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeByte(22);
        out.writeUTF(this.scriptProjectName);
        out.writeInt(this.buildNumber);
        out.writeLong(this.lastStructuralBuildTime);
        out.writeInt(this.externalFolderLocations.size());
        for (IPath path : this.externalFolderLocations) {
            out.writeUTF(path.toPortableString());
        }
        out.writeBoolean(this.noCleanExternalFolders);
    }

    public String toString() {
        return "State for " + this.scriptProjectName + " (#" + this.buildNumber + " @ " + new Date(this.lastStructuralBuildTime) + ")";
    }

    public void setNoCleanExternalFolders() {
        this.noCleanExternalFolders = true;
    }
}

