/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.builder.ScriptBuilderManager;
import org.eclipse.dltk.internal.core.builder.State;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class ScriptBuilder
extends IncrementalProjectBuilder {
    public static final boolean DEBUG = DLTKCore.DEBUG_SCRIPT_BUILDER;
    public static final boolean TRACE = false;
    public IProject currentProject = null;
    ScriptProject scriptProject = null;
    State lastState;
    public long lastBuildResources = 0L;
    public long lastBuildSourceFiles = 0L;

    public static void buildStarting() {
    }

    public static void buildFinished() {
        if (DLTKCore.DEBUG) {
            System.out.println("build finished");
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.lastBuildResources = 0L;
        this.lastBuildSourceFiles = 0L;
        this.currentProject = this.getProject();
        if (!DLTKLanguageManager.hasScriptNature(this.currentProject)) {
            return null;
        }
        this.scriptProject = (ScriptProject)DLTKCore.create(this.currentProject);
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return new IProject[0];
        }
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            this.lastState = this.getLastState(this.currentProject, monitor);
            if (this.lastState == null) {
                if (DEBUG) {
                    System.out.println("Performing full build since last saved state was not found");
                }
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        IProject[] requiredProjects = this.getRequiredProjects(true);
        if (DEBUG) {
            System.out.println("Finished build of " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        monitor.done();
        return requiredProjects;
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        if (this.scriptProject == null) {
            return new IProject[0];
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IBuildpathEntry[] entries = this.scriptProject.getExpandedBuildpath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IBuildpathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!((BuildpathEntry)entry).isOptional() || ScriptProject.hasScriptNature(p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    public State getLastState(IProject project, IProgressMonitor monitor) {
        return (State)ModelManager.getModelManager().getLastBuiltState(project, monitor);
    }

    private State clearLastState() {
        State state = new State(this);
        State cfr_ignored_0 = (State)ModelManager.getModelManager().getLastBuiltState(this.currentProject, null);
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, null);
        return state;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        State newState;
        this.lastState = newState = this.clearLastState();
        try {
            try {
                monitor.beginTask(MessageFormat.format("Building \"{0}\" project...", this.currentProject.getName()), 66);
                Set resources = this.getResourcesFrom(this.currentProject, monitor, 1);
                Set elements = this.getExternalElementsFrom(this.scriptProject, monitor, 1);
                HashSet externalFolders = new HashSet();
                externalFolders.addAll(this.lastState.externalFolderLocations);
                int totalFiles = resources.size() + elements.size();
                if (totalFiles == 0) {
                    totalFiles = 1;
                }
                int resourceTicks = 64 * resources.size() / totalFiles;
                this.buildResources(resources, monitor, resourceTicks, 1, new HashSet(), externalFolders, resources);
                ArrayList els = new ArrayList();
                els.addAll(elements);
                this.buildElements(els, elements, monitor, 64 - resourceTicks, 1, new HashSet(), externalFolders);
                this.lastBuildSourceFiles += (long)elements.size();
                this.lastBuildResources = resources.size() + elements.size();
            }
            catch (CoreException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            throw throwable;
        }
        {
            Object var9_12 = null;
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            return;
        }
    }

    private Set getResourcesFrom(Object el, IProgressMonitor monitor, int ticks) throws CoreException {
        HashSet hashSet;
        HashSet resources = new HashSet();
        String name = MessageFormat.format("Scanning \"{0}\" project...", this.currentProject.getName());
        monitor.subTask(name);
        try {
            ResourceVisitor resourceVisitor = new ResourceVisitor(resources, monitor);
            if (el instanceof IProject) {
                IProject prj = (IProject)el;
                prj.accept((IResourceVisitor)resourceVisitor);
            } else if (el instanceof IResourceDelta) {
                IResourceDelta delta = (IResourceDelta)el;
                delta.accept((IResourceDeltaVisitor)resourceVisitor);
            }
            hashSet = resources;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            monitor.worked(ticks);
            throw throwable;
        }
        monitor.worked(ticks);
        return hashSet;
    }

    private Set getExternalElementsFrom(ScriptProject prj, IProgressMonitor monitor, int tiks) throws ModelException {
        HashSet hashSet;
        HashSet elements = new HashSet();
        String name = MessageFormat.format("Scanning external resources for \"{0}\" project...", this.currentProject.getName());
        monitor.subTask(name);
        try {
            ExternalModuleVisitor visitor = new ExternalModuleVisitor(elements, monitor);
            prj.accept(visitor);
            this.lastState.externalFolderLocations.clear();
            this.lastState.externalFolderLocations.addAll(visitor.getExternalFolders());
            hashSet = elements;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.worked(tiks);
            throw throwable;
        }
        monitor.worked(tiks);
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        State newState = new State(this);
        HashSet externalFoldersBefore = new HashSet();
        HashSet externalFolders = new HashSet();
        if (this.lastState != null) {
            newState.copyFrom(this.lastState);
            externalFoldersBefore.addAll(newState.getExternalFolders());
        }
        this.lastState = newState;
        try {
            monitor.beginTask(MessageFormat.format("Building(*) \"{0}\" project...", this.currentProject.getName()), 67);
            Set allresources = this.getResourcesFrom(this.currentProject, monitor, 1);
            Set resources = this.getResourcesFrom(delta, monitor, 1);
            Set elements = this.getExternalElementsFrom(this.scriptProject, monitor, 1);
            externalFolders.addAll(this.lastState.externalFolderLocations);
            int totalFiles = resources.size() + elements.size();
            if (totalFiles == 0) {
                totalFiles = 1;
            }
            int resourceTicks = 64 * resources.size() / totalFiles;
            this.buildResources(resources, monitor, resourceTicks, 0, externalFoldersBefore, externalFolders, allresources);
            ArrayList els = new ArrayList();
            els.addAll(elements);
            this.buildElements(els, elements, monitor, 64 - resourceTicks, 0, externalFoldersBefore, externalFolders);
            this.lastBuildSourceFiles += (long)elements.size();
            this.lastBuildResources = resources.size() + elements.size();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            throw throwable;
        }
        {
            Object var12_14 = null;
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            return;
        }
    }

    protected void buildResources(Set resources, IProgressMonitor monitor, int tiks, int buildType, Set externalFoldersBefore, Set externalFolders, Set allresources) {
        HandleFactory factory = new HandleFactory();
        new ArrayList();
        IDLTKSearchScope scope = SearchEngine.createSearchScope(new IModelElement[]{this.scriptProject});
        ArrayList<Openable> realResources = new ArrayList<Openable>();
        ArrayList<Openable> elements = new ArrayList<Openable>();
        HashSet<Openable> allElements = new HashSet<Openable>();
        HashSet<IResource> allResources = new HashSet<IResource>();
        String name = "Locate Elements for " + this.scriptProject.getElementName();
        SubProgressMonitor sub = new SubProgressMonitor(monitor, tiks / 3);
        sub.beginTask(name, allresources.size());
        Iterator iterator = allresources.iterator();
        while (iterator.hasNext()) {
            IResource res = (IResource)iterator.next();
            sub.worked(1);
            if (sub.isCanceled()) {
                return;
            }
            Openable element = factory.createOpenable(res.getFullPath().toString(), scope);
            if (element != null && element.getElementType() == 5 && element.exists()) {
                allElements.add(element);
                if (!resources.contains(res)) continue;
                elements.add(element);
                continue;
            }
            if (resources.contains(res)) {
                realResources.add(element);
            }
            allResources.add(res);
        }
        sub.done();
        this.lastBuildSourceFiles += (long)elements.size();
        String[] natureIds = null;
        try {
            natureIds = this.currentProject.getDescription().getNatureIds();
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return;
        }
        if (realResources.size() == 0) {
            monitor.worked(tiks / 3);
        } else {
            HashSet<IScriptBuilder> alreadyPassed = new HashSet<IScriptBuilder>();
            int j = 0;
            while (j < natureIds.length) {
                block15: {
                    try {
                        IScriptBuilder[] builders = ScriptBuilderManager.getScriptBuilders(natureIds[j]);
                        if (builders != null) {
                            int k = 0;
                            while (k < builders.length) {
                                SubProgressMonitor ssub = new SubProgressMonitor(monitor, tiks / 3 / (builders.length * natureIds.length));
                                ssub.beginTask("Building", 1);
                                IScriptBuilder builder = builders[k];
                                if (!alreadyPassed.contains(builder)) {
                                    alreadyPassed.add(builder);
                                    builder.buildResources(this.scriptProject, realResources, (IProgressMonitor)ssub);
                                }
                                ssub.done();
                                ++k;
                            }
                        }
                    }
                    catch (CoreException e) {
                        if (!DLTKCore.DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
                ++j;
            }
        }
        this.buildElements(elements, allElements, monitor, tiks / 3, buildType, externalFoldersBefore, externalFolders);
    }

    protected void buildElements(List elements, Set allElements, IProgressMonitor monitor, int ticks, int buildType, Set externalFoldersBefore, Set externalFolders) {
        new ArrayList();
        IDLTKLanguageToolkit toolkit = null;
        try {
            toolkit = DLTKLanguageManager.getLanguageToolkit(this.scriptProject);
            IScriptBuilder[] builders = ScriptBuilderManager.getScriptBuilders(toolkit.getNatureId());
            if (builders != null) {
                List buildElementsList;
                IScriptBuilder builder;
                int total = 0;
                HashMap<IScriptBuilder, List> builderToElements = new HashMap<IScriptBuilder, List>();
                int k = 0;
                while (k < builders.length) {
                    builder = builders[k];
                    buildElementsList = this.getDependencies(elements, allElements, externalFoldersBefore, externalFolders, builder);
                    builderToElements.put(builder, buildElementsList);
                    total += buildElementsList.size();
                    ++k;
                }
                k = 0;
                while (k < builders.length) {
                    builder = builders[k];
                    buildElementsList = (List)builderToElements.get(builder);
                    int builderLength = total > 0 ? ticks * buildElementsList.size() / total : 1;
                    SubProgressMonitor sub = new SubProgressMonitor(monitor, builderLength);
                    builder.buildModelElements(this.scriptProject, buildElementsList, (IProgressMonitor)sub);
                    ++k;
                }
            }
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return;
        }
    }

    private List getDependencies(List elements, Set allElements, Set externalFoldersBefore, Set externalFolders, IScriptBuilder builder) {
        HashSet buildElements = new HashSet();
        buildElements.addAll(elements);
        List dependencies = builder.getDependencies(this.scriptProject, elements);
        if (dependencies != null) {
            buildElements.addAll(dependencies);
        }
        ArrayList buildElementsList = new ArrayList();
        buildElementsList.addAll(buildElements);
        return buildElementsList;
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.dltk.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.dltk.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void writeState(Object state, DataOutputStream out) throws IOException {
        ((State)state).write(out);
    }

    public static State readState(IProject project, DataInputStream in) throws IOException {
        State state = State.read(project, in);
        return state;
    }

    class ExternalModuleVisitor
    implements IModelElementVisitor {
        private Set elements;
        private IProgressMonitor monitor;
        private Set fragments = new HashSet();

        public ExternalModuleVisitor(Set elements, IProgressMonitor monitor) {
            this.elements = elements;
            this.monitor = monitor;
        }

        public boolean visit(IModelElement element) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (element.getElementType() == 3) {
                if (!(element instanceof ExternalProjectFragment) && !(element instanceof BuiltinProjectFragment)) {
                    return false;
                }
                IProjectFragment fragment = (IProjectFragment)element;
                this.fragments.add(fragment.getPath());
                if (ScriptBuilder.this.lastState.externalFolderLocations.contains(fragment.getPath())) {
                    return false;
                }
                ScriptBuilder.this.lastState.externalFolderLocations.add(fragment.getPath());
            }
            if (element.getElementType() == 5 && (element instanceof ExternalSourceModule || element instanceof BuiltinSourceModule)) {
                if (!this.elements.contains(element)) {
                    this.elements.add(element);
                }
                return false;
            }
            return true;
        }

        public Set getExternalFolders() {
            return this.fragments;
        }
    }

    static class ResourceVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private Set resources;
        private IProgressMonitor monitor;

        public ResourceVisitor(Set resources, IProgressMonitor monitor) {
            this.resources = resources;
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    if (this.resources.contains(resource) || resource.getType() != 1) break;
                    this.resources.add(resource);
                    return false;
                }
            }
            return true;
        }

        public boolean visit(IResource resource) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (!this.resources.contains(resource) && resource.getType() == 1) {
                this.resources.add(resource);
                return false;
            }
            return true;
        }
    }
}

