/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.python.parser.ast.statements.TryStatement;
import org.eclipse.dltk.utils.CorePrinter;

public class PythonTryStatement
extends TryStatement {
    private Statement fElseStatement;

    public PythonTryStatement(DLTKToken q, Block body, List catchFin) {
        super(q, body, catchFin);
        if (body != null && body.sourceEnd() > this.sourceEnd()) {
            this.setEnd(body.sourceEnd());
        }
        if (catchFin != null) {
            for (ASTNode node : catchFin) {
                if (node.sourceEnd() <= this.sourceEnd()) continue;
                this.setEnd(node.sourceEnd());
            }
        }
    }

    public void setElseStatement(Statement elseStatement) {
        this.fElseStatement = elseStatement;
        if (this.fElseStatement != null && this.fElseStatement.sourceEnd() > this.sourceEnd()) {
            this.setEnd(this.fElseStatement.sourceEnd());
        }
    }

    @Override
    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            Block body = this.getBody();
            List catchsFinallyStatements = this.getCatchFinallyStatements();
            if (body != null) {
                body.traverse(pVisitor);
            }
            if (catchsFinallyStatements != null) {
                for (Statement st : catchsFinallyStatements) {
                    st.traverse(pVisitor);
                }
            }
            if (this.fElseStatement != null) {
                this.fElseStatement.traverse(pVisitor);
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrintLn("try:");
        Block body = this.getBody();
        List catchFinallyStatements = this.getCatchFinallyStatements();
        if (body != null) {
            body.printNode(output);
        }
        if (catchFinallyStatements != null) {
            for (Statement st : catchFinallyStatements) {
                st.printNode(output);
            }
        }
        if (this.fElseStatement != null) {
            output.formatPrintLn("else:");
            if (!(this.fElseStatement instanceof Block)) {
                output.indent();
            }
            this.fElseStatement.printNode(output);
            if (!(this.fElseStatement instanceof Block)) {
                output.dedent();
            }
        }
    }
}

