/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.rules;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class StartWithRule
implements IRule {
    private IToken token;
    private char[] start;
    private boolean noSameBefore = false;

    public StartWithRule(IToken token, char start) {
        this.token = token;
        this.start = new char[]{start};
    }

    public StartWithRule(IToken token, char[] start) {
        this.token = token;
        this.start = start;
    }

    public StartWithRule(IToken token, char start, boolean nsb) {
        this.token = token;
        this.start = new char[]{start};
        this.noSameBefore = nsb;
    }

    protected char[] getAdditional() {
        return CharOperation.NO_CHAR;
    }

    boolean isInAddition(char c) {
        char[] additional = this.getAdditional();
        int i = 0;
        while (i < additional.length) {
            if (additional[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        char c1;
        if (scanner.getColumn() > 0) {
            scanner.unread();
            int cc = scanner.read();
            if (!Character.isWhitespace((char)cc) && (char)cc != '(' && (char)cc != '{' && (char)cc != '/' && (char)cc != '!' && (char)cc != '%' && (char)cc != '^' && (char)cc != '&' && (char)cc != '*' && (char)cc != '-' && (char)cc != '+' && (char)cc != '=' && (char)cc != '[' && (char)cc != '|' && (char)cc != '?' && (char)cc != ':' && (char)cc != '<' && (char)cc != '>' && (char)cc != ',') {
                return Token.UNDEFINED;
            }
        }
        if (this.noSameBefore && scanner.getColumn() != 0) {
            scanner.unread();
            int c = scanner.read();
            if ((char)c == this.start[0]) {
                return Token.UNDEFINED;
            }
        }
        if ((c1 = (char)scanner.read()) == this.start[0]) {
            int index = 1;
            char ch = (char)scanner.read();
            if (Character.isJavaIdentifierStart(ch) || this.isInAddition(ch) || this.start.length > index && this.start[index] == ch) {
                int c;
                while (Character.isJavaIdentifierPart((char)(c = scanner.read())) || this.isInAddition((char)c) || this.start.length > ++index && this.start[index] == ch) {
                }
                scanner.unread();
                return this.token;
            }
            scanner.unread();
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

