/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.tcl.core.TclPlugin;

public class TclCheckContentExclude
implements Preferences.IPropertyChangeListener {
    private char[][] cachedPatterns = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExcluded(String name) {
        char[][] patterns;
        TclCheckContentExclude tclCheckContentExclude = this;
        synchronized (tclCheckContentExclude) {
            if (this.cachedPatterns == null) {
                Preferences prefs = TclPlugin.getDefault().getPluginPreferences();
                this.initPatterns(prefs.getString("check_content.excludes"));
                prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
            }
            patterns = this.cachedPatterns;
        }
        if (patterns.length != 0) {
            int i = 0;
            while (i < patterns.length) {
                char[] pattern = patterns[i];
                if (TclCheckContentExclude.match(pattern, name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void initPatterns(String value) {
        this.cachedPatterns = CharOperation.splitOn((char)';', (char[])value.toCharArray());
        if (this.cachedPatterns == null) {
            this.cachedPatterns = CharOperation.NO_CHAR_CHAR;
        }
    }

    private static final boolean match(char[] pattern, String name) {
        int patternEnd = pattern.length;
        int nameEnd = name.length();
        int iPattern = 0;
        int iName = 0;
        char patternChar = '\u0000';
        while (iPattern < patternEnd && (patternChar = pattern[iPattern]) != '*') {
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != Character.toLowerCase(name.charAt(iName)) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if (Character.toLowerCase(name.charAt(iName)) != patternChar && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if ("check_content.excludes".equals(event.getProperty())) {
            TclCheckContentExclude tclCheckContentExclude = this;
            synchronized (tclCheckContentExclude) {
                this.initPatterns((String)event.getNewValue());
            }
        }
    }
}

