/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.testing.internal.xounit;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestingClient;
import org.eclipse.dltk.testing.ITestingProcessor;
import org.eclipse.dltk.testing.model.ITestRunSession;
import org.eclipse.dltk.xotcl.testing.internal.xounit.XOUnitTestingEngine;

class XOUnitOutputProcessor
implements ITestingProcessor {
    private ILaunch launch;
    long start;
    private ISourceModule module;
    Map testNameToId;
    int index;
    private ITestRunSession session;
    private ITestingClient client;
    private boolean skip;
    private String message;
    private int state;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_RESULT_WAS = 1;
    private static final int STATE_RESULT_ACTUAL = 2;
    private String resultActual;
    private String resultExpected;
    int total;
    int currentTest;
    boolean inTrace;
    String actual;
    String expected;
    String testPrefix;

    public XOUnitOutputProcessor(ILaunch launch) {
        block2: {
            this.start = 0L;
            this.testNameToId = new HashMap();
            this.index = 0;
            this.skip = false;
            this.message = "";
            this.state = 0;
            this.resultActual = "";
            this.resultExpected = "";
            this.total = 0;
            this.currentTest = -1;
            this.inTrace = false;
            this.actual = "";
            this.expected = "";
            this.launch = launch;
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            try {
                this.module = AbstractScriptLaunchConfigurationDelegate.getSourceModule((ILaunchConfiguration)launchConfiguration);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void done() {
        this.checkEndTest();
        if (this.session == null || this.client == null) {
            return;
        }
        this.session.setTotalCount(this.total);
        this.client.testTerminated((int)(System.currentTimeMillis() - this.start));
    }

    public void processLine(String line) {
        if (this.session == null || this.client == null) {
            return;
        }
        if (line.length() == 0) {
            return;
        }
        if (!this.skip) {
            if (line.startsWith("Pass:")) {
                this.checkEndTest();
                line = line.trim();
                String[] split = line.split(" ");
                if (split.length >= 3) {
                    this.testPrefix = String.valueOf(split[1]) + "::" + split[2];
                    if (this.testNameToId.containsKey(this.testPrefix)) {
                        int id = (Integer)this.testNameToId.get(this.testPrefix);
                        this.client.testEnded(id, this.testPrefix);
                    }
                }
                this.resetState();
            } else if (line.startsWith("Error:")) {
                this.checkEndTest();
                line = line.trim();
                String[] split = line.split(" ");
                if (split.length >= 3) {
                    this.testPrefix = String.valueOf(split[1]) + "::" + split[2];
                    if (this.testNameToId.containsKey(this.testPrefix)) {
                        this.currentTest = (Integer)this.testNameToId.get(this.testPrefix);
                        this.client.testError(this.currentTest, this.testPrefix);
                        this.client.testEnded(this.currentTest, this.testPrefix);
                        this.client.testActual("");
                        this.client.testExpected("");
                        this.client.traceStart();
                        this.inTrace = true;
                    }
                }
            } else if (line.startsWith("Failure:")) {
                this.checkEndTest();
                line = line.trim();
                String[] split = line.split(" ");
                if (split.length >= 3) {
                    this.testPrefix = String.valueOf(split[1]) + "::" + split[2];
                    if (this.testNameToId.containsKey(this.testPrefix)) {
                        this.currentTest = (Integer)this.testNameToId.get(this.testPrefix);
                        this.client.testFailed(this.currentTest, this.testPrefix);
                    }
                }
            } else if (line.startsWith("Actual:")) {
                this.actual = line.substring("Actual:".length());
            } else if (line.startsWith("Expected:")) {
                this.expected = line.substring("Expected:".length());
            } else if (line.startsWith("=================")) {
                this.checkEndTest();
            } else if (this.inTrace) {
                this.client.traceMessage(line);
            }
        }
    }

    private void checkEndTest() {
        if (this.currentTest == -1) {
            return;
        }
        if (this.inTrace) {
            this.client.traceEnd();
        } else {
            this.client.testActual(this.actual);
            this.client.testExpected(this.expected);
            this.client.traceStart();
            this.client.traceEnd();
            this.client.testEnded(this.currentTest, this.testPrefix);
        }
        this.inTrace = false;
        this.currentTest = -1;
    }

    private void resetState() {
        this.state = 0;
        this.resultActual = "";
        this.resultExpected = "";
    }

    public void start() {
        this.start = System.currentTimeMillis();
        this.index = 0;
        this.session = DLTKTestingPlugin.getTestRunSession((ILaunch)this.launch);
        if (this.session == null) {
            return;
        }
        this.client = this.session.getTestRunnerClient();
        if (this.client != null) {
            this.client.testRunStart(0);
        }
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)this.module, null);
        this.processModule(moduleDeclaration);
    }

    private void processModule(ModuleDeclaration moduleDeclaration) {
        if (moduleDeclaration == null) {
            return;
        }
        TypeDeclaration[] tests = XOUnitTestingEngine.findTests(moduleDeclaration);
        this.total = 0;
        this.total = this.processSubtests(tests, moduleDeclaration);
        this.session.setTotalCount(this.total);
    }

    private int processSubtests(TypeDeclaration[] tests, ModuleDeclaration moduleDeclaration) {
        int summ = 0;
        int i = 0;
        while (i < tests.length) {
            int id = ++this.index;
            TypeDeclaration[] subtests = this.getSubtest(tests[i]);
            String testName = tests[i].getName();
            String testPrefix = TclParseUtil.getElementFQN((ASTNode)tests[i], (String)"::", (ModuleDeclaration)moduleDeclaration);
            if (!testPrefix.startsWith("::")) {
                testPrefix = "::" + testPrefix;
            }
            this.testNameToId.put(testPrefix, new Integer(id));
            MethodDeclaration[] testCases = XOUnitTestingEngine.getTestCases(tests[i]);
            if (subtests.length + testCases.length > 0) {
                this.client.testTree(id, testName, true, subtests.length + testCases.length);
                this.client.testStarted(id, testName);
                summ += this.processSubtests(subtests, moduleDeclaration);
                int j = 0;
                while (j < testCases.length) {
                    int testCaseId = ++this.index;
                    String testCaseName = testCases[j].getName();
                    String testCasePrefix = TclParseUtil.getElementFQN((ASTNode)testCases[j], (String)"::", (ModuleDeclaration)moduleDeclaration);
                    if (!testCasePrefix.startsWith("::")) {
                        testCasePrefix = "::" + testCasePrefix;
                    }
                    this.testNameToId.put(testCasePrefix, new Integer(testCaseId));
                    this.client.testTree(testCaseId, String.valueOf(testCaseName) + "(" + testPrefix + ")", false, 0);
                    this.client.testStarted(testCaseId, String.valueOf(testCaseName) + "(" + testPrefix + ")");
                    ++j;
                }
                summ += testCases.length;
            }
            ++i;
        }
        return summ;
    }

    private TypeDeclaration[] getSubtest(TypeDeclaration typeDeclaration) {
        return XOUnitTestingEngine.getTests(typeDeclaration);
    }
}

