/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.VariableValue;
import org.eclipse.dltk.tcl.internal.ui.GlobalVariableBlock;
import org.eclipse.dltk.tcl.internal.ui.preferences.ProjectBuildJob;
import org.eclipse.dltk.ui.dialogs.IStatusDialog;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class TclGlobalVariablesPropertyPage
extends PropertyPage {
    private final GlobalVariableBlock variableBlock = new GlobalVariableBlock(new StatusDialogAdapter());

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.variableBlock.createControlsIn(composite);
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        this.variableBlock.setValues((EMap<String, VariableValue>)TclPackagesManager.getVariablesEMap((String)project.getName()));
        return composite;
    }

    public boolean performOk() {
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        EMap oldVars = TclPackagesManager.getVariablesEMap((String)project.getName());
        EMap<String, VariableValue> newVars = this.variableBlock.getValues();
        if (!GlobalVariableBlock.equalsEMap(newVars, (EMap<String, VariableValue>)oldVars)) {
            TclPackagesManager.setVariables((String)project.getName(), newVars);
            new ProjectBuildJob(project).schedule(500L);
        }
        return super.performOk();
    }

    private class StatusDialogAdapter
    implements IStatusDialog {
        private StatusDialogAdapter() {
        }

        public Shell getShell() {
            return TclGlobalVariablesPropertyPage.this.getShell();
        }

        public void setButtonLayoutData(Button button) {
            TclGlobalVariablesPropertyPage.this.setButtonLayoutData(button);
        }

        public void updateStatusLine() {
        }
    }
}

