/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.expressions;

import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.utils.CorePrinter;

public class NumericLiteral
extends Literal {
    private long intValue;

    public NumericLiteral(DLTKToken number) {
        super(number);
    }

    public NumericLiteral(int start, int end, long value) {
        super(start, end);
        this.intValue = value;
    }

    public long getIntValue() {
        return this.intValue;
    }

    @Override
    public String getValue() {
        return String.valueOf(this.intValue);
    }

    @Override
    public int getKind() {
        return 1055;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrintLn(this.getValue());
    }
}

