/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import java.util.LinkedList;
import org.eclipse.dltk.dbgp.internal.packets.DbgpPacket;
import org.eclipse.dltk.dbgp.internal.packets.Messages;

public final class DbgpPacketWaiter {
    private static final String DBGP_PACKET_RECEIVER_PACKET_WAITER_TERMINATED = Messages.DbgpPacketReceiver_packetWaiterTerminated;
    private final LinkedList queue = new LinkedList();
    private boolean terminated = false;

    public synchronized void put(DbgpPacket obj) {
        this.queue.addLast(obj);
        this.notifyAll();
    }

    public synchronized DbgpPacket waitPacket() throws InterruptedException {
        while (!this.terminated && this.queue.isEmpty()) {
            this.wait();
        }
        if (this.terminated) {
            throw new InterruptedException(DBGP_PACKET_RECEIVER_PACKET_WAITER_TERMINATED);
        }
        return (DbgpPacket)this.queue.removeFirst();
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.notifyAll();
    }
}

