/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import java.util.HashMap;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.goals.NonTypeConstantTypeGoal;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;

public class NonTypeConstantTypeEvaluator
extends GoalEvaluator {
    private HashMap<String, RubyClassType> hardcoredTypes = new HashMap();
    private Object result;

    public NonTypeConstantTypeEvaluator(IGoal goal) {
        super(goal);
        this.hardcoredTypes.put("FALSE", new RubyClassType("FalseClass%"));
        this.hardcoredTypes.put("RUBY_RELEASE_DATE", new RubyClassType("String%"));
        this.hardcoredTypes.put("STDERR", new RubyClassType("IO%"));
        this.hardcoredTypes.put("MatchingData", new RubyClassType("Class%"));
        this.hardcoredTypes.put("TOPLEVEL_BINDING", new RubyClassType("Binding%"));
        this.hardcoredTypes.put("ENV", new RubyClassType("Object%"));
        this.hardcoredTypes.put("STDIN", new RubyClassType("IO%"));
        this.hardcoredTypes.put("TRUE", new RubyClassType("TrueClass%"));
        this.hardcoredTypes.put("RELEASE_DATE", new RubyClassType("String%"));
        this.hardcoredTypes.put("NIL", new RubyClassType("NilClass%"));
        this.hardcoredTypes.put("RUBY_PLATFORM", new RubyClassType("String%"));
        this.hardcoredTypes.put("RUBY_VERSION", new RubyClassType("String%"));
        this.hardcoredTypes.put("STDOUT", new RubyClassType("IO%"));
        this.hardcoredTypes.put("PLATFORM", new RubyClassType("String%"));
        this.hardcoredTypes.put("ARGV", new RubyClassType("Array%"));
        this.hardcoredTypes.put("ARGF", new RubyClassType("Object%"));
        this.hardcoredTypes.put("VERSION", new RubyClassType("String%"));
    }

    private NonTypeConstantTypeGoal getTypedGoal() {
        return (NonTypeConstantTypeGoal)this.goal;
    }

    public IGoal[] init() {
        NonTypeConstantTypeGoal g = this.getTypedGoal();
        IMixinElement element = g.getElement();
        Object[] allObjects = element.getAllObjects();
        if (allObjects == null) {
            return IGoal.NO_GOALS;
        }
        int i = 0;
        while (i < allObjects.length) {
            IField field;
            String name;
            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
            if (info != null && info.getKind() == 3 && info.getObject() instanceof IField && this.hardcoredTypes.containsKey(name = (field = (IField)info.getObject()).getElementName())) {
                this.result = this.hardcoredTypes.get(name);
                break;
            }
            ++i;
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

