/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import org.eclipse.dltk.ruby.internal.parser.mixin.IMixinSearchPattern;

public class PrefixNoCaseMixinSearchPattern
implements IMixinSearchPattern {
    private final String key;
    private final char[] chars;

    public PrefixNoCaseMixinSearchPattern(String key) {
        this.key = key;
        this.chars = key.toLowerCase().toCharArray();
    }

    @Override
    public boolean evaluate(String lastSegment) {
        int length = this.chars.length;
        if (lastSegment.length() < length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (Character.toLowerCase(lastSegment.charAt(i)) != this.chars[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

