/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.python.internal.ui.text.PythonAutoEditStrategy;
import org.eclipse.dltk.python.internal.ui.text.PythonCodeScanner;
import org.eclipse.dltk.python.internal.ui.text.PythonStringScanner;
import org.eclipse.dltk.python.internal.ui.text.PythonTextTools;
import org.eclipse.dltk.python.internal.ui.text.completion.PythonCompletionProcessor;
import org.eclipse.dltk.python.internal.ui.text.completion.PythonContentAssistPreference;
import org.eclipse.dltk.python.ui.text.IPythonPartitions;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PythonSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private PythonTextTools fTextTools;
    private PythonCodeScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fCommentScanner;

    public PythonSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return IPythonPartitions.PYTHON_PARTITION_TYPES;
    }

    protected void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new PythonCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new PythonStringScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = this.createCommentScanner("DLTK_single_line_comment", "DLTK_comment_task_tag");
    }

    private boolean isNewSetup() {
        return this.fTextTools == null;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__python_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__python_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__python_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__python_comment");
        return reconciler;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        return new IAutoEditStrategy[]{new PythonAutoEditStrategy(this.fPreferenceStore, partitioning)};
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return PythonContentAssistPreference.getDefault();
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        PythonCompletionProcessor processor = new PythonCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
    }
}

