/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.ParameterData;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.SourceAnalyzer;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.IfStatement;
import org.eclipse.dltk.javascript.core.dom.IterationStatement;
import org.eclipse.dltk.javascript.core.dom.LabeledStatement;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.ReturnStatement;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class SourceProvider {
    private FunctionExpression declaration;
    private SourceAnalyzer analyzer;
    private String code;
    private boolean mustEvalReturnedExpression;

    public SourceProvider(FunctionExpression declaration, IMethod method) {
        this.declaration = declaration;
        this.analyzer = new SourceAnalyzer(declaration, method);
    }

    public RefactoringStatus checkActivation() {
        return this.analyzer.checkActivation();
    }

    public void initialize() throws ModelException {
        this.analyzer.initialize();
        this.code = this.analyzer.getCode();
        EList<Statement> list = this.declaration.getBody().getStatements();
        if (list.isEmpty()) {
            return;
        }
        Node last = (Node)list.get(list.size() - 1);
        if (last.eClass().getClassifierID() == 45) {
            this.analyzeReturn(last);
        }
    }

    private void analyzeReturn(Node ret) {
        TreeIterator it = ret.eAllContents();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            switch (node.eClass().getClassifierID()) {
                case 25: 
                case 26: {
                    this.mustEvalReturnedExpression = true;
                    return;
                }
            }
        }
    }

    public boolean isExecutionFlowInterrupted() {
        return this.analyzer.isExecutionFlowInterrupted();
    }

    public boolean mustEvaluateReturnedExpression() {
        return this.mustEvalReturnedExpression;
    }

    public boolean isSimpleFunction() {
        EList<Statement> statements = this.declaration.getBody().getStatements();
        if (statements.size() != 1) {
            return false;
        }
        return statements.get(0) instanceof ReturnStatement;
    }

    public boolean isDanglingIf() {
        EList<Statement> statements = this.declaration.getBody().getStatements();
        if (statements.size() != 1) {
            return false;
        }
        Statement last = (Statement)statements.get(0);
        block6: while (true) {
            switch (last.eClass().getClassifierID()) {
                case 36: {
                    return ((IfStatement)last).getAlternative() == null;
                }
                case 31: {
                    return false;
                }
                case 38: 
                case 39: 
                case 40: 
                case 42: 
                case 76: {
                    last = ((IterationStatement)last).getBody();
                    continue block6;
                }
                case 51: {
                    last = ((LabeledStatement)last).getStatement();
                    continue block6;
                }
            }
            break;
        }
        return false;
    }

    public FunctionExpression getDeclaration() {
        return this.declaration;
    }

    public ParameterData getParameterData(int index) {
        return this.analyzer.getParameterData(index);
    }

    public int getReceiversToBeUpdated() {
        return this.analyzer.getImplicitReceiversCount();
    }

    public String getCode() {
        return this.code;
    }

    private Statement getLastStatement() {
        EList<Statement> statements = this.declaration.getBody().getStatements();
        if (statements.isEmpty()) {
            return null;
        }
        return (Statement)statements.get(statements.size() - 1);
    }

    public ISourceModule getSourceModule() {
        return this.analyzer.getSourceModule();
    }
}

