/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.indexing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.caching.ArchiveCacheIndexBuilder;
import org.eclipse.dltk.core.caching.ArchiveIndexContentChecker;
import org.eclipse.dltk.core.caching.MixinModelCollector;
import org.eclipse.dltk.core.caching.StructureModelCollector;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.indexing.NullIndexer;
import org.eclipse.dltk.tcl.internal.core.TclSourceIndexerRequestor;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinBuildVisitor;
import org.eclipse.dltk.tcl.internal.core.serialization.TclASTSaver;
import org.eclipse.dltk.tcl.internal.parser.NewTclSourceParser;
import org.eclipse.dltk.tcl.internal.parser.TclSourceElementRequestVisitor;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.dltk.utils.TextUtils;

public class DLTKEFSTclIndexer {
    private long totalSize = 0L;
    private long totalIndexesSize = 0L;
    private long totalASTIndexesSize = 0L;
    public static final long VERSION = 200905291444L;

    public boolean isForceRebuild() {
        return false;
    }

    public void buildIndexFor(IFileStore folder, boolean recursive) {
        IFileStore[] files;
        IFileInfo folderInfo = folder.fetchInfo();
        if (!folderInfo.isDirectory()) {
            return;
        }
        try {
            files = folder.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            return;
        }
        ArrayList<IFileStore> toIndex = new ArrayList<IFileStore>();
        IFileStore[] iFileStoreArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore file = iFileStoreArray[n2];
            IFileInfo fileInfo = file.fetchInfo();
            if (fileInfo.isDirectory() && recursive) {
                this.buildIndexFor(file, recursive);
            } else if (this.needIndexing(file)) {
                toIndex.add(file);
            }
            ++n2;
        }
        boolean readonly = folderInfo.getAttribute(2);
        if (readonly) {
            this.logReadonlyFolder(folder);
        }
        if (!toIndex.isEmpty() && !readonly) {
            boolean buildRequired = this.isForceRebuild();
            IFileStore indexFile = folder.getChild(".dltk.index");
            IFileStore astIndexFile = folder.getChild(".dltk.index.ast");
            IFileInfo indexFileInfo = indexFile.fetchInfo();
            IFileInfo astIndexFileInfo = astIndexFile.fetchInfo();
            if (!buildRequired && !indexFileInfo.exists()) {
                buildRequired = true;
            }
            if (!buildRequired && !astIndexFileInfo.exists()) {
                buildRequired = true;
            }
            if (!buildRequired) {
                try {
                    File indexFileLocal = indexFile.toLocalFile(4096, (IProgressMonitor)new NullProgressMonitor());
                    ArchiveIndexContentChecker checker = new ArchiveIndexContentChecker(indexFileLocal, 200905291444L, TclLanguageToolkit.getDefault());
                    if (checker.containChanges(indexFile)) {
                        buildRequired = true;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (!buildRequired) {
                try {
                    File astIndexFileLocal = indexFile.toLocalFile(4096, (IProgressMonitor)new NullProgressMonitor());
                    ArchiveIndexContentChecker astChecker = new ArchiveIndexContentChecker(astIndexFileLocal, 200905291444L, TclLanguageToolkit.getDefault());
                    if (astChecker.containChanges(astIndexFile)) {
                        buildRequired = true;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (!buildRequired) {
                this.logIndexConsistent(folder);
                return;
            }
            this.logBeginOfFolder(folder);
            this.deleteIndexFiles(indexFile, astIndexFile);
            long filesSize = 0L;
            try {
                ArchiveCacheIndexBuilder builder = new ArchiveCacheIndexBuilder(indexFile.openOutputStream(0, (IProgressMonitor)new NullProgressMonitor()), 200905291444L);
                ArchiveCacheIndexBuilder astIndexBuilder = new ArchiveCacheIndexBuilder(astIndexFile.openOutputStream(0, (IProgressMonitor)new NullProgressMonitor()), 200905291444L);
                for (IFileStore file : toIndex) {
                    filesSize += this.indexFile(builder, astIndexBuilder, file);
                }
                builder.done();
                astIndexBuilder.done();
                this.logEntry(indexFile, filesSize);
                this.totalSize += filesSize;
                indexFileInfo = indexFile.fetchInfo();
                astIndexFileInfo = astIndexFile.fetchInfo();
                this.totalIndexesSize += indexFileInfo.getLength();
                this.totalASTIndexesSize += astIndexFileInfo.getLength();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.deleteIndexFiles(indexFile, astIndexFile);
            }
            catch (IOException iOException) {
                this.deleteIndexFiles(indexFile, astIndexFile);
            }
            catch (Exception exception) {
                this.reportUnknownError(folder);
                this.deleteIndexFiles(indexFile, astIndexFile);
            }
        }
    }

    public void logReadonlyFolder(IFileStore folder) {
    }

    private long indexFile(ArchiveCacheIndexBuilder builder, ArchiveCacheIndexBuilder astIndexBuilder, IFileStore file) throws CoreException, IOException, Exception {
        String content = new String(Util.getFileByteContent((IFileStore)file));
        ProblemCollector dltkProblems = new ProblemCollector();
        TclModule module = this.makeModule(content, dltkProblems);
        IFileInfo fileInfo = file.fetchInfo();
        long timestamp = fileInfo.getLastModified();
        if (fileInfo.getAttribute(32)) {
            String target = fileInfo.getStringAttribute(64);
            IFileStore linkTarget = file.getFileStore((IPath)new Path(target));
            IFileInfo info = linkTarget.fetchInfo();
            timestamp = info.getLastModified();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        TclASTSaver saver = new TclASTSaver();
        saver.save(module, dltkProblems, (OutputStream)bout);
        astIndexBuilder.addEntry(file.getName(), timestamp, "_ast", (InputStream)new ByteArrayInputStream(bout.toByteArray()));
        TclSourceIndexerRequestor req = new TclSourceIndexerRequestor();
        req.setIndexer(new NullIndexer());
        StructureModelCollector collector = new StructureModelCollector((ISourceElementRequestor)req);
        NewTclSourceParser parser = new NewTclSourceParser();
        ModuleDeclaration ast = parser.parse(null, module, null);
        TclSourceElementRequestVisitor requestor = new TclSourceElementRequestVisitor((ISourceElementRequestor)collector, null);
        ast.traverse((ASTVisitor)requestor);
        byte[] structure_index = collector.getBytes();
        builder.addEntry(file.getName(), timestamp, "_sind", (InputStream)new ByteArrayInputStream(structure_index));
        MixinModelCollector mixinCollector = new MixinModelCollector();
        TclMixinBuildVisitor mixinVisitor = new TclMixinBuildVisitor(ast, null, false, (IMixinRequestor)mixinCollector);
        ast.traverse((ASTVisitor)mixinVisitor);
        byte[] mixin_index = mixinCollector.getBytes();
        builder.addEntry(file.getName(), timestamp, "_smix", (InputStream)new ByteArrayInputStream(mixin_index));
        return content.length();
    }

    private void deleteIndexFiles(IFileStore indexFile, IFileStore astIndexFile) {
        try {
            IFileInfo astIndexFileInfo;
            IFileInfo indexFileInfo = indexFile.fetchInfo();
            if (indexFileInfo.exists()) {
                indexFile.delete(0, (IProgressMonitor)new NullProgressMonitor());
            }
            if ((astIndexFileInfo = astIndexFile.fetchInfo()).exists()) {
                astIndexFile.delete(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {}
    }

    protected void logIndexConsistent(IFileStore folder) {
    }

    public void logBeginOfFolder(IFileStore folder) {
    }

    public void logEntry(IFileStore indexFile, long filesSize) {
    }

    protected void reportUnknownError(IFileStore folder) {
    }

    private TclModule makeModule(String content, ProblemCollector dltkProblems) {
        TclParser parser = new TclParser();
        TclErrorCollector collector = new TclErrorCollector();
        TclModule module = parser.parseModule(content, (ITclErrorReporter)collector, (IScopeProcessor)DefinitionManager.getInstance().createProcessor());
        if (dltkProblems != null) {
            collector.reportAll((IProblemReporter)dltkProblems, TextUtils.createLineTracker((String)content));
        }
        return module;
    }

    private boolean needIndexing(IFileStore file) {
        IFileInfo fileInfo = file.fetchInfo();
        if (fileInfo.isDirectory()) {
            return false;
        }
        return DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)TclLanguageToolkit.getDefault(), (String)file.getName());
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getTotalIndexesSize() {
        return this.totalIndexesSize + this.totalASTIndexesSize;
    }

    public long getBasicIndexesSize() {
        return this.totalIndexesSize;
    }

    public long getASTIndexesSize() {
        return this.totalASTIndexesSize;
    }
}

