/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;

public class CutAction
extends SelectionDispatchAction {
    private CopyToClipboardAction fCopyToClipboardAction;

    public CutAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        this.setText(ReorgMessages.CutAction_text);
        this.fCopyToClipboardAction = new CopyToClipboardAction(site, clipboard, pasteAction);
        ISharedImages workbenchImages = DLTKUIPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            try {
                if (!CutAction.containsOnlyElementsInsideSourceModules(selection) || CutAction.containsTopLevelTypes(selection)) {
                    this.setEnabled(false);
                    return;
                }
                this.fCopyToClipboardAction.selectionChanged(selection);
                this.setEnabled(this.fCopyToClipboardAction.isEnabled() && RefactoringAvailabilityTester.isDeleteAvailable(selection));
            }
            catch (CoreException e) {
                if (ScriptModelUtil.isExceptionToBeLogged((CoreException)e)) {
                    DLTKUIPlugin.log(e);
                }
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    private static boolean containsOnlyElementsInsideSourceModules(IStructuredSelection selection) {
        for (Object object : selection) {
            if (object instanceof IModelElement && ReorgUtils.isInsideSourceModule((IModelElement)object)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTopLevelTypes(IStructuredSelection selection) {
        for (Object each : selection) {
            if (!(each instanceof IType) || ((IType)each).getDeclaringType() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            this.selectionChanged(selection);
            if (this.isEnabled()) {
                this.fCopyToClipboardAction.run(selection);
                RefactoringExecutionStarter.startCutRefactoring(selection.toArray(), this.getShell());
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

