/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.internal.testing.launcher.DLTKTestingMigrationDelegate;
import org.eclipse.dltk.internal.ui.ModelElementComparator;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.ruby.internal.debug.ui.launchConfigurations.RubyMainLaunchConfigurationTab;
import org.eclipse.dltk.ruby.testing.internal.Messages;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.ITestingEngine;
import org.eclipse.dltk.testing.TestingEngineDetectResult;
import org.eclipse.dltk.testing.TestingEngineManager;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class RubyTestingMainLaunchConfigurationTab
extends RubyMainLaunchConfigurationTab {
    private Button detect;
    private Combo engineType;
    private Map nameToId = new HashMap();
    private Label engineMessageLabel;
    private Label engineMessageImageLabel;
    private Button fTestRadioButton;
    private Button fTestContainerRadioButton;
    private Label fProjectLabel;
    private Label fScriptLabel;
    private Text fContainerText;
    private Button fContainerSearchButton;
    private IModelElement fContainerElement;
    private final ILabelProvider fModelElementLabelProvider = new ModelElementLabelProvider();
    private String message = "";
    private Image messageImage;

    public RubyTestingMainLaunchConfigurationTab(String mode) {
        super(mode);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        this.fTestRadioButton = new Button(comp, 16);
        this.fTestRadioButton.setText(DLTKTestingMessages.JUnitLaunchConfigurationTab_label_oneTest);
        this.fTestRadioButton.setLayoutData((Object)this.createModeGridData());
        this.fTestRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RubyTestingMainLaunchConfigurationTab.this.fTestRadioButton.getSelection()) {
                    RubyTestingMainLaunchConfigurationTab.this.testModeChanged();
                }
            }
        });
        comp.setLayout((Layout)topLayout);
        this.createProjectEditor(comp);
        this.createMainModuleEditor(comp, DLTKLaunchConfigurationsMessages.mainTab_mainModule);
        this.createVerticalSpacer(comp, 1);
        this.fTestContainerRadioButton = new Button(comp, 16);
        this.fTestContainerRadioButton.setText(DLTKTestingMessages.JUnitLaunchConfigurationTab_label_containerTest);
        this.fTestContainerRadioButton.setLayoutData((Object)this.createModeGridData());
        this.fTestContainerRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RubyTestingMainLaunchConfigurationTab.this.fTestContainerRadioButton.getSelection()) {
                    RubyTestingMainLaunchConfigurationTab.this.testModeChanged();
                }
            }
        });
        this.fContainerText = new Text(comp, 2060);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 25;
        gd.horizontalSpan = 2;
        this.fContainerText.setLayoutData((Object)gd);
        this.fContainerText.addModifyListener((ModifyListener)this.getWidgetListener());
        this.fContainerSearchButton = this.createPushButton(comp, DLTKTestingMessages.JUnitLaunchConfigurationTab_label_search, null);
        this.fContainerSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RubyTestingMainLaunchConfigurationTab.this.handleContainerSearchButtonSelected();
            }
        });
        this.createVerticalSpacer(comp, 1);
        this.createTestEngineEditor(comp, Messages.RubyTestingMainLaunchConfigurationTab_rubyTestingEngine);
        this.createVerticalSpacer(comp, 1);
        this.createDebugOptionsGroup(comp);
        this.createCustomSections(comp);
        Dialog.applyDialogFont((Control)comp);
    }

    protected void handleContainerSearchButtonSelected() {
        IModelElement element = this.chooseContainer(this.fContainerElement);
        if (element != null) {
            this.setContainerElement(element);
            this.setProjectName(element.getScriptProject().getElementName());
        }
    }

    private void setContainerElement(IModelElement javaElement) {
        this.fContainerElement = javaElement;
        this.fContainerText.setText(this.getPresentationName(javaElement));
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    protected boolean validate() {
        boolean result;
        this.updateEngineStatus();
        if (this.fTestContainerRadioButton.getSelection()) {
            if (this.fContainerElement == null) {
                this.setErrorMessage(DLTKTestingMessages.JUnitLaunchConfigurationTab_error_noContainer);
                return false;
            }
            result = this.validateProject(this.fContainerElement.getScriptProject());
        } else {
            result = super.validate();
        }
        return result && this.validateEngine();
    }

    private String getPresentationName(IModelElement element) {
        return this.fModelElementLabelProvider.getText((Object)element);
    }

    private IModelElement chooseContainer(IModelElement initElement) {
        Class[] acceptedClasses = new Class[]{IProjectFragment.class, IScriptProject.class, IScriptFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                return true;
            }
        };
        acceptedClasses = new Class[]{IScriptModel.class, IProjectFragment.class, IScriptProject.class, IScriptFolder.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                IProjectFragment fragment;
                if (element instanceof IScriptProject && !RubyTestingMainLaunchConfigurationTab.this.getNatureID().equals(((IScriptProject)element).getLanguageToolkit().getNatureId())) {
                    return false;
                }
                if (element instanceof IProjectFragment && ((fragment = (IProjectFragment)element).isExternal() || fragment.isArchive())) {
                    return false;
                }
                try {
                    if (element instanceof IScriptFolder && !((IScriptFolder)element).hasChildren()) {
                        return false;
                    }
                }
                catch (ModelException modelException) {
                    return false;
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardModelElementContentProvider provider = new StandardModelElementContentProvider();
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new ModelElementComparator());
        dialog.setTitle(DLTKTestingMessages.JUnitLaunchConfigurationTab_folderdialog_title);
        dialog.setMessage(DLTKTestingMessages.JUnitLaunchConfigurationTab_folderdialog_message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()));
        dialog.setInitialSelection((Object)initElement);
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            return (IModelElement)element;
        }
        return null;
    }

    private GridData createModeGridData() {
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        return gd;
    }

    protected boolean needGroupForField(String fieldName) {
        return !"project".equals(fieldName) && !"mainScript".equals(fieldName);
    }

    protected Label createLabelForField(Composite parent, String fieldName, String text) {
        Label label = super.createLabelForField(parent, fieldName, text);
        if ("project".equals(fieldName) || "mainScript".equals(fieldName)) {
            label.setLayoutData((Object)this.createIndentedGridData());
        }
        if ("project".equals(fieldName)) {
            this.fProjectLabel = label;
        } else if ("mainScript".equals(fieldName)) {
            this.fScriptLabel = label;
        }
        return label;
    }

    private GridData createIndentedGridData() {
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        return gd;
    }

    protected final void doCreateControl(Composite composite) {
    }

    private void testModeChanged() {
        IScriptProject project;
        String projText;
        boolean isSingleTestMode = this.fTestRadioButton.getSelection();
        this.setEnableSingleTestGroup(isSingleTestMode);
        this.setEnableContainerTestGroup(!isSingleTestMode);
        if (!isSingleTestMode && this.fContainerText.getText().length() == 0 && Path.EMPTY.isValidSegment(projText = this.getProjectName()) && (project = this.getScriptModel().getScriptProject(projText)) != null && project.exists()) {
            this.setContainerElement((IModelElement)project);
        }
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    private void setEnableSingleTestGroup(boolean enabled) {
        this.fProjectLabel.setEnabled(enabled);
        this.setEnableProjectField(enabled);
        this.fScriptLabel.setEnabled(enabled);
        this.setEnableScriptField(enabled);
    }

    protected void projectChanged() {
        this.testModeChanged();
    }

    private void setEnableContainerTestGroup(boolean enabled) {
        this.fContainerSearchButton.setEnabled(enabled);
        this.fContainerText.setEnabled(enabled);
    }

    protected void createTestEngineEditor(Composite parent, String text) {
        Label fTestEngine = new Label(parent, 0);
        fTestEngine.setText(text);
        this.engineType = new Combo(parent, 2052);
        GridData gd = new GridData(768);
        this.engineType.setLayoutData((Object)gd);
        this.engineType.addModifyListener((ModifyListener)this.getWidgetListener());
        this.detect = this.createPushButton(parent, DLTKTestingMessages.MainLaunchConfigurationTab_detectEngine, null);
        ITestingEngine[] engines = TestingEngineManager.getEngines((String)this.getNatureID());
        int i = 0;
        while (i < engines.length) {
            String name = engines[i].getName();
            this.engineType.add(name);
            this.nameToId.put(name, engines[i].getId());
            ++i;
        }
        this.detect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RubyTestingMainLaunchConfigurationTab.this.handleDetectButtonSelected();
            }
        });
        new Label(parent, 0);
        Composite engineStatusComposite = new Composite(parent, 0);
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns - 1;
        engineStatusComposite.setLayoutData((Object)gd);
        engineStatusComposite.setLayout((Layout)new RowLayout());
        this.engineMessageImageLabel = new Label(engineStatusComposite, 0);
        this.engineMessageLabel = new Label(engineStatusComposite, 0);
    }

    private void handleDetectButtonSelected() {
        ITestingEngine[] engines;
        TestingEngineDetectResult result;
        ISourceModule module = this.getSourceModule();
        if (module != null && module.exists() && (result = TestingEngineManager.detect((ITestingEngine[])(engines = TestingEngineManager.getEngines((String)this.getNatureID())), (ISourceModule)module)) != null) {
            this.engineType.select(Arrays.asList(engines).indexOf(result.getEngine()));
            this.updateEngineStatus(result.getStatus());
        }
    }

    private void updateEngineStatus(IStatus status) {
        Image newImage = null;
        String newMessage = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                newMessage = "";
                break;
            }
            case 1: {
                newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                break;
            }
            case 2: {
                newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                break;
            }
            case 4: {
                newImage = JFaceResources.getImage((String)"dialog_message_error_image");
            }
        }
        this.showMessage(newMessage, newImage);
    }

    private void showMessage(String newMessage, Image newImage) {
        if (this.message.equals(newMessage) && this.messageImage == newImage) {
            return;
        }
        this.message = newMessage;
        if (this.message == null) {
            this.message = "";
        }
        this.messageImage = newImage;
        this.engineMessageImageLabel.setImage(newImage);
        this.engineMessageLabel.setText(this.message);
    }

    private void updateEngineStatus() {
        this.updateEngineStatus(TestingEngineManager.getEngine((String)this.getEngineId()));
    }

    private void updateEngineStatus(ITestingEngine engine) {
        ISourceModule module;
        IStatus status = Status.OK_STATUS;
        if (engine != null && this.fTestRadioButton.getSelection() && (module = this.getSourceModule()) != null) {
            status = engine.validateSourceModule(module);
        }
        if (status != null) {
            this.updateEngineStatus(status);
        }
    }

    protected ISourceModule getSourceModule() {
        if (!this.fTestRadioButton.getSelection()) {
            return null;
        }
        return super.getSourceModule();
    }

    private boolean validateEngine() {
        if (TestingEngineManager.getEngine((String)this.getEngineId()) == null) {
            this.setErrorMessage(DLTKTestingMessages.MainLaunchConfigurationTab_ErrorEngineNotSelected);
            return false;
        }
        return true;
    }

    protected void setDefaults(ILaunchConfigurationWorkingCopy configuration, IModelElement element) {
        if ((element = this.ensureValid(element)) != null) {
            if (element.getElementType() >= 5) {
                if ((element = element.getAncestor(5)) != null) {
                    super.setDefaults(configuration, element);
                    TestingEngineDetectResult detection = TestingEngineManager.detect((ITestingEngine[])TestingEngineManager.getEngines((String)this.getNatureID()), (ISourceModule)((ISourceModule)element));
                    if (detection != null) {
                        configuration.setAttribute("org.eclipse.dltk.testing.engineId", detection.getEngine().getId());
                    }
                }
            } else {
                configuration.setAttribute("project", element.getScriptProject().getElementName());
                configuration.setAttribute("org.eclipse.dltk.testing.CONTAINER", element.getHandleIdentifier());
            }
        }
    }

    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        if (this.fTestContainerRadioButton.getSelection() && this.fContainerElement != null) {
            config.setAttribute("project", this.fContainerElement.getScriptProject().getElementName());
            config.setAttribute("org.eclipse.dltk.testing.CONTAINER", this.fContainerElement.getHandleIdentifier());
            config.setAttribute("mainScript", "");
        } else {
            config.setAttribute("project", this.getProjectName());
            config.setAttribute("mainScript", this.getScriptName());
            config.setAttribute("org.eclipse.dltk.testing.CONTAINER", "");
        }
        this.performApplyInteractiveConsole(config);
        config.setAttribute("org.eclipse.dltk.testing.engineId", this.getEngineId());
    }

    protected void mapResources(ILaunchConfigurationWorkingCopy config) throws CoreException {
        DLTKTestingMigrationDelegate.mapResources((ILaunchConfigurationWorkingCopy)config);
    }

    private String getEngineId() {
        return (String)this.nameToId.get(this.engineType.getText());
    }

    protected void doInitializeForm(ILaunchConfiguration config) {
        String id;
        block10: {
            this.initializeInteractiveConsoleFrom(config);
            String containerHandle = "";
            try {
                containerHandle = config.getAttribute("org.eclipse.dltk.testing.CONTAINER", "");
            }
            catch (CoreException coreException) {}
            if (containerHandle.length() > 0) {
                this.updateTestContainerFromConfig(config);
            } else {
                this.updateTestScriptFromConfig(config);
            }
            id = null;
            try {
                id = config.getAttribute("org.eclipse.dltk.testing.engineId", "");
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block10;
                e.printStackTrace();
            }
        }
        if (id == null || id.length() == 0) {
            this.handleDetectButtonSelected();
        } else {
            ITestingEngine[] engines = TestingEngineManager.getEngines((String)this.getNatureID());
            int i = 0;
            while (i < engines.length) {
                ITestingEngine engine = engines[i];
                if (engine.getId().equals(id)) {
                    this.engineType.select(i);
                    this.updateEngineStatus(engine);
                    break;
                }
                ++i;
            }
        }
    }

    private void updateTestScriptFromConfig(ILaunchConfiguration config) {
        this.updateMainModuleFromConfig(config);
        this.fTestRadioButton.setSelection(true);
        this.setEnableSingleTestGroup(true);
        this.setEnableContainerTestGroup(false);
        this.fTestContainerRadioButton.setSelection(false);
        this.fContainerText.setText("");
    }

    private void updateTestContainerFromConfig(ILaunchConfiguration config) {
        String containerHandle = "";
        IModelElement containerElement = null;
        try {
            containerHandle = config.getAttribute("org.eclipse.dltk.testing.CONTAINER", "");
            if (containerHandle.length() > 0) {
                containerElement = DLTKCore.create((String)containerHandle);
            }
        }
        catch (CoreException coreException) {}
        if (containerElement != null) {
            this.fContainerElement = containerElement;
        }
        this.fTestContainerRadioButton.setSelection(true);
        this.setEnableSingleTestGroup(false);
        this.setEnableContainerTestGroup(true);
        this.fTestRadioButton.setSelection(false);
        if (this.fContainerElement != null) {
            this.fContainerText.setText(this.getPresentationName(this.fContainerElement));
        }
        this.setScriptName("");
    }
}

