/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.rewrite;

import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.BinaryOperator;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.ParenthesizedExpression;
import org.eclipse.dltk.javascript.core.dom.PropertyAccessExpression;
import org.eclipse.dltk.javascript.core.dom.SimplePropertyAssignment;
import org.eclipse.dltk.javascript.core.dom.UnaryOperator;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;

public class RefactoringUtils {
    private RefactoringUtils() {
    }

    public static CallExpression getFunctionReference(Node node) {
        if (node.eContainingFeature() == DomPackage.eINSTANCE.getCallExpression_Applicant()) {
            return (CallExpression)node.eContainer();
        }
        if (node.eContainingFeature() == DomPackage.eINSTANCE.getPropertyAccessExpression_Property()) {
            return RefactoringUtils.getFunctionReference((Node)node.eContainer());
        }
        return null;
    }

    public static FunctionExpression getFunctionDeclaration(Node node) {
        Expression right;
        BinaryExpression expr;
        Expression initializer;
        Expression func;
        Node parent;
        if (node.eContainingFeature() == DomPackage.eINSTANCE.getFunctionExpression_Identifier()) {
            return (FunctionExpression)node.eContainer();
        }
        if (node.eContainingFeature() == DomPackage.eINSTANCE.getPropertyAssignment_Name() && (parent = (Node)node.eContainer()) instanceof SimplePropertyAssignment && (func = ((SimplePropertyAssignment)parent).getInitializer()) instanceof FunctionExpression) {
            return (FunctionExpression)func;
        }
        if (node.eContainingFeature() == DomPackage.eINSTANCE.getVariableDeclaration_Identifier() && (initializer = ((VariableDeclaration)node.eContainer()).getInitializer()) instanceof FunctionExpression) {
            return (FunctionExpression)initializer;
        }
        if (node.eContainingFeature() == DomPackage.eINSTANCE.getPropertyAccessExpression_Property() && (parent = (Node)node.eContainer()).eContainingFeature() == DomPackage.eINSTANCE.getBinaryExpression_Left() && (expr = (BinaryExpression)parent.eContainer()).getOperation() == BinaryOperator.ASSIGN && (right = expr.getRight()) instanceof FunctionExpression) {
            return (FunctionExpression)right;
        }
        return null;
    }

    public static boolean isAssignment(BinaryOperator op) {
        switch (op) {
            case ASSIGN: 
            case MUL_ASSIGN: 
            case DIV_ASSIGN: 
            case MOD_ASSIGN: 
            case ADD_ASSIGN: 
            case SUB_ASSIGN: 
            case LSH_ASSIGN: 
            case RSH_ASSIGN: 
            case URSH_ASSIGN: 
            case AND_ASSIGN: 
            case XOR_ASSIGN: 
            case OR_ASSIGN: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasSideEffect(UnaryOperator op) {
        switch (op) {
            case POSTFIX_INC: 
            case POSTFIX_DEC: 
            case DELETE: 
            case PREFIX_INC: 
            case PREFIX_DEC: {
                return true;
            }
        }
        return false;
    }

    public static Expression getReceiver(CallExpression invocation) {
        Expression func = invocation.getApplicant();
        while (func instanceof ParenthesizedExpression) {
            func = ((ParenthesizedExpression)func).getEnclosed();
        }
        if (!(func instanceof PropertyAccessExpression)) {
            return null;
        }
        return ((PropertyAccessExpression)func).getObject();
    }
}

