/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.Collections;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRTypeTransformer;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

class RArrayType
extends RType
implements IRArrayType {
    private final IRType itemType;
    private final IRTypeDeclaration declaration;

    public RArrayType(ITypeSystem typeSystem, IRType itemType) {
        this.itemType = itemType;
        this.declaration = typeSystem.parameterize(Types.ARRAY, Collections.singletonList(itemType));
    }

    @Override
    public Type getTarget() {
        return Types.ARRAY;
    }

    @Override
    public IRTypeDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public String getName() {
        return "Array<" + this.itemType.getName() + '>';
    }

    @Override
    public IRType getItemType() {
        return this.itemType;
    }

    public int hashCode() {
        return this.itemType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RArrayType) {
            RArrayType other = (RArrayType)obj;
            return this.itemType.equals(other.itemType);
        }
        return false;
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (super.isAssignableFrom(type).ok()) {
            return TypeCompatibility.TRUE;
        }
        if (type instanceof RArrayType) {
            IRType ortherItem = ((RArrayType)type).itemType;
            if (ortherItem == RTypes.EMPTY_ARRAY_ITEM_TYPE) {
                return TypeCompatibility.TRUE;
            }
            TypeCompatibility compatibility = this.itemType.isAssignableFrom(ortherItem);
            return compatibility == TypeCompatibility.TRUE ? compatibility : TypeCompatibility.UNPARAMETERIZED;
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public IRType transform(IRTypeTransformer function) {
        IRType value = function.transform(this.itemType);
        if (value != this.itemType) {
            return new RArrayType(this.declaration.getTypeSystem(), value);
        }
        return this;
    }
}

