/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.dltk.core.index.sql.File;
import org.eclipse.dltk.core.index.sql.IFileDao;
import org.eclipse.dltk.internal.core.index.sql.h2.H2Cache;

public class H2FileDao
implements IFileDao {
    private static final String Q_INSERT = "INSERT INTO FILES(PATH,TIMESTAMP,CONTAINER_ID) VALUES(?,?,?);";
    private static final String Q_SELECT = "SELECT * FROM FILES WHERE PATH=? AND CONTAINER_ID=?;";
    private static final String Q_SELECT_BY_CONTAINER_ID = "SELECT * FROM FILES WHERE CONTAINER_ID=?;";
    private static final String Q_SELECT_BY_ID = "SELECT * FROM FILES WHERE ID=?;";
    private static final String Q_DELETE = "DELETE FROM FILES WHERE PATH=? AND CONTAINER_ID=?;";
    private static final String Q_DELETE_BY_ID = "DELETE FROM FILES WHERE ID=?;";

    public File insert(Connection connection, String path, long timestamp, int containerId) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(Q_INSERT, 1);
        try {
            File file;
            int param = 0;
            statement.setString(++param, path);
            statement.setLong(++param, timestamp);
            statement.setInt(++param, containerId);
            statement.executeUpdate();
            ResultSet result = statement.getGeneratedKeys();
            try {
                result.next();
                File file2 = new File(result.getInt(1), path, timestamp, containerId);
                H2Cache.addFile(file2);
                file = file2;
            }
            catch (Throwable throwable) {
                result.close();
                throw throwable;
            }
            result.close();
            return file;
        }
        finally {
            statement.close();
        }
    }

    public File select(Connection connection, String path, int containerId) throws SQLException {
        File file = H2Cache.selectFileByContainerIdAndPath(containerId, path);
        if (file == null) {
            PreparedStatement statement = connection.prepareStatement(Q_SELECT);
            try {
                int param = 0;
                statement.setString(++param, path);
                statement.setInt(++param, containerId);
                ResultSet result = statement.executeQuery();
                try {
                    if (result.next()) {
                        file = new File(result.getInt(1), result.getString(2), result.getLong(3), result.getInt(4));
                        H2Cache.addFile(file);
                    }
                }
                finally {
                    result.close();
                }
            }
            finally {
                statement.close();
            }
        }
        return file;
    }

    public File[] selectByContainerId(Connection connection, int containerId) throws SQLException {
        Collection<File> files = H2Cache.selectFilesByContainerId(containerId);
        if (files == null) {
            files = new LinkedList<File>();
            PreparedStatement statement = connection.prepareStatement(Q_SELECT_BY_CONTAINER_ID);
            try {
                int param = 0;
                statement.setInt(++param, containerId);
                ResultSet result = statement.executeQuery();
                try {
                    while (result.next()) {
                        File file = new File(result.getInt(1), result.getString(2), result.getLong(3), result.getInt(4));
                        files.add(file);
                        H2Cache.addFile(file);
                    }
                }
                finally {
                    result.close();
                }
            }
            finally {
                statement.close();
            }
        }
        return files.toArray(new File[files.size()]);
    }

    public File selectById(Connection connection, int id) throws SQLException {
        File file = H2Cache.selectFileById(id);
        if (file == null) {
            PreparedStatement statement = connection.prepareStatement(Q_SELECT_BY_ID);
            try {
                int param = 0;
                statement.setInt(++param, id);
                ResultSet result = statement.executeQuery();
                try {
                    if (result.next()) {
                        file = new File(result.getInt(1), result.getString(2), result.getLong(3), result.getInt(4));
                        H2Cache.addFile(file);
                    }
                }
                finally {
                    result.close();
                }
            }
            finally {
                statement.close();
            }
        }
        return file;
    }

    public void delete(Connection connection, String path, int containerId) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(Q_DELETE);
        try {
            int param = 0;
            statement.setString(++param, path);
            statement.setInt(++param, containerId);
            statement.executeUpdate();
        }
        finally {
            statement.close();
        }
        H2Cache.deleteFileByContainerIdAndPath(containerId, path);
    }

    public void deleteById(Connection connection, int id) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(Q_DELETE_BY_ID);
        try {
            int param = 0;
            statement.setInt(++param, id);
            statement.executeUpdate();
        }
        finally {
            statement.close();
        }
        H2Cache.deleteFileById(id);
    }
}

