/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.folding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.folding.AbortFoldingException;
import org.eclipse.dltk.ui.text.folding.DefaultElementCommentResolver;
import org.eclipse.dltk.ui.text.folding.FoldingProviderManager;
import org.eclipse.dltk.ui.text.folding.IElementCommentResolver;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockRequestor;
import org.eclipse.dltk.ui.text.folding.IFoldingContent;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProviderExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DelegatingFoldingStructureProvider
implements IFoldingStructureProvider,
IFoldingStructureProviderExtension {
    private static final boolean DEBUG = false;
    private ITextEditor fEditor;
    private IFoldingBlockProvider[] blockProviders;
    private ProjectionListener fProjectionListener;
    private IModelElement fInput;
    private IElementChangedListener fElementListener;
    private final Filter fMemberFilter = new MemberFilter();
    private final Filter fCommentFilter = new CommentFilter();
    private IPreferenceStore fStore;
    private final Lock lock = new Lock();

    @Override
    public void install(ITextEditor editor, ProjectionViewer viewer, IPreferenceStore store) {
        this.internalUninstall();
        this.fStore = store;
        if (editor instanceof ScriptEditor) {
            this.fEditor = editor;
            this.fProjectionListener = new ProjectionListener(viewer);
            this.blockProviders = FoldingProviderManager.getBlockProviders(((ScriptEditor)this.fEditor).getLanguageToolkit().getNatureId());
        }
    }

    @Override
    public void uninstall() {
        this.internalUninstall();
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
            this.blockProviders = null;
        }
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.fEditor instanceof ScriptEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    protected void handleProjectionDisabled() {
        if (this.fElementListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    @Override
    public final void initialize() {
        this.initialize(false);
    }

    @Override
    public final void initialize(boolean isReinit) {
        this.update(this.createInitialContext(isReinit));
    }

    protected FoldingStructureComputationContext createInitialContext(boolean isReinit) {
        if (this.blockProviders != null) {
            IFoldingBlockProvider[] iFoldingBlockProviderArray = this.blockProviders;
            int n = this.blockProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IFoldingBlockProvider provider = iFoldingBlockProviderArray[n2];
                provider.initializePreferences(this.fStore);
                ++n2;
            }
        }
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(!isReinit);
    }

    protected FoldingStructureComputationContext createInitialContext() {
        return this.createInitialContext(true);
    }

    protected FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return new FoldingStructureComputationContext(doc, model, allowCollapse);
    }

    private IModelElement getInputElement() {
        if (this.fEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
    }

    protected void update(FoldingStructureComputationContext ctx) {
        if (ctx == null) {
            return;
        }
        if (this.lock.lock()) {
            try {
                this.update0(ctx);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void update0(FoldingStructureComputationContext ctx) {
        HashMap<ScriptProjectionAnnotation, Position> additions = new HashMap<ScriptProjectionAnnotation, Position>();
        ArrayList<ScriptProjectionAnnotation> deletions = new ArrayList<ScriptProjectionAnnotation>();
        ArrayList<ScriptProjectionAnnotation> updates = new ArrayList<ScriptProjectionAnnotation>();
        if (!this.computeFoldingStructure(ctx)) {
            return;
        }
        LinkedHashMap<Annotation, Position> updated = ctx.fMap;
        Map<AnnotationKey, List<Tuple>> previous = this.computeCurrentStructure(ctx);
        for (ScriptProjectionAnnotation newAnnotation : updated.keySet()) {
            AnnotationKey stamp = newAnnotation.stamp;
            Position newPosition = (Position)updated.get((Object)newAnnotation);
            List<Tuple> annotations = previous.get(stamp);
            if (annotations == null) {
                additions.put(newAnnotation, newPosition);
                continue;
            }
            Iterator<Tuple> x = annotations.iterator();
            boolean matched = false;
            if (x.hasNext()) {
                Tuple tuple = x.next();
                ScriptProjectionAnnotation existingAnnotation = tuple.annotation;
                Position existingPosition = tuple.position;
                if (existingPosition != null && (!newPosition.equals((Object)existingPosition) || ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed())) {
                    existingPosition.setOffset(newPosition.getOffset());
                    existingPosition.setLength(newPosition.getLength());
                    if (ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed()) {
                        if (newAnnotation.isCollapsed()) {
                            existingAnnotation.markCollapsed();
                        } else {
                            existingAnnotation.markExpanded();
                        }
                    }
                    updates.add(existingAnnotation);
                }
                matched = true;
                x.remove();
            }
            if (!matched) {
                additions.put(newAnnotation, newPosition);
            }
            if (!annotations.isEmpty()) continue;
            previous.remove(stamp);
        }
        for (List<Tuple> list : previous.values()) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                deletions.add(list.get((int)i).annotation);
                ++i;
            }
        }
        if (!(deletions.isEmpty() && additions.isEmpty() && updated.isEmpty())) {
            ctx.getModel().modifyAnnotations(deletions.toArray(new Annotation[deletions.size()]), additions, updates.toArray(new Annotation[updates.size()]));
        }
    }

    private boolean computeFoldingStructure(FoldingStructureComputationContext ctx) {
        block6: {
            if (this.blockProviders != null) break block6;
            return false;
        }
        try {
            FoldingContent content = new FoldingContent(this.fInput);
            Requestor requestor = new Requestor(content, ctx);
            IFoldingBlockProvider[] iFoldingBlockProviderArray = this.blockProviders;
            int n = this.blockProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IFoldingBlockProvider provider = iFoldingBlockProviderArray[n2];
                provider.setRequestor(requestor);
                requestor.lineCountDelta = Math.max(1, provider.getMinimalLineCount() - 1);
                provider.computeFoldableBlocks(content);
                provider.setRequestor(null);
                ++n2;
            }
            return true;
        }
        catch (ModelException modelException) {
            return false;
        }
        catch (AbortFoldingException abortFoldingException) {
            return false;
        }
        catch (RuntimeException e) {
            DLTKUIPlugin.logErrorMessage("Error in FoldingBlockProvider", e);
            this.blockProviders = null;
            return false;
        }
    }

    public static IFoldingContent createContent(IModelElement input) throws ModelException {
        return new FoldingContent(input);
    }

    public IElementCommentResolver createElementCommentResolver(IModelElement modelElement, String contents) {
        return new DefaultElementCommentResolver((ISourceModule)modelElement, contents);
    }

    protected boolean isEmptyRegion(IDocument d, ITypedRegion r) throws BadLocationException {
        return this.isEmptyRegion(d, r.getOffset(), r.getLength());
    }

    protected boolean isBlankRegion(IDocument document, ITypedRegion region) throws BadLocationException {
        String value = document.get(region.getOffset(), region.getLength());
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch != ' ' && ch != '\t') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isEmptyRegion(IDocument d, int offset, int length) throws BadLocationException {
        return d.get(offset, length).trim().length() == 0;
    }

    protected static final Position createCommentPosition(IRegion aligned) {
        return new CommentPosition(aligned.getOffset(), aligned.getLength());
    }

    protected static final Position createMemberPosition(IRegion aligned) {
        return new ScriptElementPosition(aligned.getOffset(), aligned.getLength());
    }

    protected static IRegion alignRegion(IRegion region, FoldingStructureComputationContext ctx, int lineCountDelta) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = ctx.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(region.getOffset() + region.getLength());
                if (start + lineCountDelta <= end) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }

    private ProjectionAnnotationModel getModel() {
        return (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
    }

    private IDocument getDocument() {
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fEditor.getEditorInput());
    }

    private Map<AnnotationKey, List<Tuple>> computeCurrentStructure(FoldingStructureComputationContext ctx) {
        HashMap<AnnotationKey, List<Tuple>> map = new HashMap<AnnotationKey, List<Tuple>>();
        ProjectionAnnotationModel model = ctx.getModel();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof ScriptProjectionAnnotation)) continue;
            ScriptProjectionAnnotation ann = (ScriptProjectionAnnotation)((Object)annotation);
            Position position = model.getPosition((Annotation)ann);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(ann.stamp);
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(ann.stamp, list);
            }
            list.add(new Tuple(ann, position));
        }
        Comparator<Tuple> comparator = new Comparator<Tuple>(){

            @Override
            public int compare(Tuple o1, Tuple o2) {
                return o1.position.getOffset() - o2.position.getOffset();
            }
        };
        for (List list : map.values()) {
            Collections.sort(list, comparator);
        }
        return map;
    }

    @Override
    public final void collapseMembers() {
        this.modifyFiltered(this.fMemberFilter, false);
    }

    @Override
    public final void collapseComments() {
        this.modifyFiltered(this.fCommentFilter, false);
    }

    private void modifyFiltered(Filter filter, boolean expand) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return;
        }
        ArrayList<ScriptProjectionAnnotation> modified = new ArrayList<ScriptProjectionAnnotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            ScriptProjectionAnnotation annot;
            Object annotation = iter.next();
            if (!(annotation instanceof ScriptProjectionAnnotation) || expand != (annot = (ScriptProjectionAnnotation)((Object)annotation)).isCollapsed() || !filter.match(annot)) continue;
            if (expand) {
                annot.markExpanded();
            } else {
                annot.markCollapsed();
            }
            modified.add(annot);
        }
        model.modifyAnnotations(null, null, modified.toArray(new Annotation[modified.size()]));
    }

    protected final IModelElement getModuleElement() {
        return this.fInput;
    }

    @Override
    public void expandElements(final IModelElement[] array) {
        this.modifyFiltered(new Filter(){

            @Override
            public boolean match(ScriptProjectionAnnotation annotation) {
                Object element = annotation.getElement();
                if (!(element instanceof IModelElement)) {
                    return false;
                }
                int a = 0;
                while (a < array.length) {
                    IModelElement e = array[a];
                    if (e.equals(element)) {
                        return true;
                    }
                    ++a;
                }
                return false;
            }
        }, true);
    }

    @Override
    public void collapseElements(IModelElement[] modelElements) {
    }

    protected static final class AnnotationKey {
        final IFoldingBlockKind kind;
        final Object element;

        public AnnotationKey(IFoldingBlockKind kind, Object element) {
            this.kind = kind;
            this.element = element;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AnnotationKey) {
                AnnotationKey other = (AnnotationKey)obj;
                return this.kind == other.kind && this.element.equals(other.element);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public String toString() {
            return String.valueOf(this.kind.toString()) + " " + this.element.toString();
        }
    }

    private static final class CommentFilter
    implements Filter {
        @Override
        public boolean match(ScriptProjectionAnnotation annotation) {
            return annotation.getKind().isComment() && !annotation.isMarkedDeleted();
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent(sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent(sequence, 0);
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        public void elementChanged(ElementChangedEvent e) {
            IModelElementDelta delta = this.findElement(DelegatingFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null && (delta.getFlags() & 9) != 0) {
                DelegatingFoldingStructureProvider.this.update(DelegatingFoldingStructureProvider.this.createContext(false));
            }
        }

        private IModelElementDelta findElement(IModelElement target, IModelElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (element.getElementType() > 5) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static interface Filter {
        public boolean match(ScriptProjectionAnnotation var1);
    }

    private static class FoldingContent
    implements IFoldingContent {
        private final IModelElement input;
        private final String contents;

        public FoldingContent(IModelElement input) throws ModelException {
            this.input = input;
            this.contents = ((ISourceReference)input).getSource();
        }

        public String get() {
            return this.contents;
        }

        @Override
        public String get(int offset, int length) {
            return this.contents.substring(offset, offset + length);
        }

        @Override
        public String substring(int beginIndex, int endIndex) {
            return this.contents.substring(beginIndex, endIndex);
        }

        @Override
        public String get(IRegion region) {
            return this.get(region.getOffset(), region.getLength());
        }

        public char[] getContentsAsCharArray() {
            return this.get().toCharArray();
        }

        public IModelElement getModelElement() {
            return this.input;
        }

        public String getSourceContents() {
            return this.get();
        }

        public String getFileName() {
            return this.input.getElementName();
        }
    }

    public static final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        protected LinkedHashMap<Annotation, Position> fMap = new LinkedHashMap();

        public FoldingStructureComputationContext(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing) {
            this.fDocument = document;
            this.fModel = model;
            this.fAllowCollapsing = allowCollapsing;
        }

        public Map<Annotation, Position> getMap() {
            return this.fMap;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        IDocument getDocument() {
            return this.fDocument;
        }

        ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        public void addProjectionRange(ScriptProjectionAnnotation annotation, Position position) {
            this.fMap.put((Annotation)annotation, position);
        }
    }

    static class Lock {
        private boolean locked;

        Lock() {
        }

        synchronized boolean lock() {
            if (!this.locked) {
                this.locked = true;
                return true;
            }
            return false;
        }

        synchronized void unlock() {
            this.locked = false;
        }
    }

    private static final class MemberFilter
    implements Filter {
        @Override
        public boolean match(ScriptProjectionAnnotation annotation) {
            return !annotation.isMarkedDeleted() && annotation.getElement() instanceof IMember;
        }
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer viewer) {
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            DelegatingFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            DelegatingFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }

    private static class Requestor
    implements IFoldingBlockRequestor {
        final IFoldingContent content;
        final FoldingStructureComputationContext ctx;
        int lineCountDelta;

        public Requestor(IFoldingContent content, FoldingStructureComputationContext ctx) {
            this.content = content;
            this.ctx = ctx;
        }

        @Override
        public void acceptBlock(int start, int end, IFoldingBlockKind kind, Object element, boolean collapse) {
            block5: {
                try {
                    Position position;
                    Region region = new Region(start, end - start);
                    IRegion normalized = DelegatingFoldingStructureProvider.alignRegion((IRegion)region, this.ctx, this.lineCountDelta);
                    if (normalized == null) {
                        return;
                    }
                    if (element == null) {
                        element = new SourceRangeStamp(region.getLength(), this.content.get((IRegion)region).hashCode());
                    }
                    Position position2 = position = kind.isComment() ? DelegatingFoldingStructureProvider.createCommentPosition(normalized) : DelegatingFoldingStructureProvider.createMemberPosition(normalized);
                    if (position == null) {
                        return;
                    }
                    this.ctx.addProjectionRange(new ScriptProjectionAnnotation(this.ctx.allowCollapsing() && collapse, kind, element), position);
                }
                catch (StringIndexOutOfBoundsException e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
    }

    private static final class ScriptElementPosition
    extends Position
    implements IProjectionPosition {
        public ScriptElementPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) {
            return 0;
        }
    }

    private static final class ScriptProjectionAnnotation
    extends ProjectionAnnotation {
        final AnnotationKey stamp;

        public ScriptProjectionAnnotation(boolean isCollapsed, IFoldingBlockKind kind, Object element) {
            super(isCollapsed);
            this.stamp = new AnnotationKey(kind, element);
        }

        public Object getElement() {
            return this.stamp.element;
        }

        IFoldingBlockKind getKind() {
            return this.stamp.kind;
        }

        public String toString() {
            return "ScriptProjectionAnnotation(collapsed: " + this.isCollapsed() + ", " + "element:" + this.getElement() + ", " + "kind: " + this.getKind() + ")";
        }
    }

    private static class SourceRangeStamp {
        final int length;
        final int hashCode;

        public SourceRangeStamp(int length, int hashCode) {
            this.length = length;
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceRangeStamp) {
                SourceRangeStamp other = (SourceRangeStamp)obj;
                return this.length == other.length && this.hashCode == other.hashCode;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode);
        }
    }

    private static final class Tuple {
        final ScriptProjectionAnnotation annotation;
        final Position position;

        Tuple(ScriptProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[" + this.position.toString() + "]";
        }
    }
}

