/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse.ssh;

import com.jcraft.jsch.Session;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.dltk.ssh.core.ISshConnection;
import org.eclipse.dltk.ssh.core.SshConnectionManager;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;

public class RSESshManager {
    private static final String RSE_SSH_CONNECTOR_SERVICE_CLASSNAME = "org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService";
    private static final String SSH_CONNECTOR_SERVICE_GETSESSION_METHODNAME = "getSession";
    private static Set<IHost> hostsInInitialization = new HashSet<IHost>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ISshConnection getConnection(final IHost host) {
        Set<IHost> set = hostsInInitialization;
        synchronized (set) {
            if (hostsInInitialization.contains(host)) {
                return null;
            }
        }
        IConnectorService[] connectorServices = host.getConnectorServices();
        IRSESystemType systemType = host.getSystemType();
        if (!systemType.getId().equals("org.eclipse.rse.systemtype.ssh")) {
            return null;
        }
        IConnectorService[] iConnectorServiceArray = connectorServices;
        int n = connectorServices.length;
        int n2 = 0;
        while (n2 < n) {
            final IConnectorService connector = iConnectorServiceArray[n2];
            final String userId = connector.getUserId();
            String location = String.valueOf(userId) + "@" + host.getHostName();
            final ISshConnection connection = SshConnectionManager.getConnection((String)location);
            if (connection.isDisabled()) {
                return null;
            }
            if (connection.isConnected()) {
                return connection;
            }
            Thread connectionInitializationThread = new Thread(){

                public void run() {
                    if (DLTKRSEPlugin.getDefault() != null) {
                        RSESshManager.initializeConnection(host, connector, userId, connection);
                    }
                }
            };
            connectionInitializationThread.start();
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeConnection(IHost host, IConnectorService connector, String userId, ISshConnection connection) {
        block29: {
            Set<IHost> set;
            block28: {
                Set<IHost> set2 = hostsInInitialization;
                synchronized (set2) {
                    if (hostsInInitialization.contains(host)) {
                        return;
                    }
                    hostsInInitialization.add(host);
                }
                try {
                    if (!connector.isConnected()) {
                        connector.connect((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (Exception e) {
                    DLTKRSEPlugin.log(e);
                }
                if (connector.isConnected()) break block28;
                connection.setDisabled(600000);
                Set<IHost> set3 = hostsInInitialization;
                {
                    catch (Throwable throwable) {
                        Set<IHost> set4 = hostsInInitialization;
                        synchronized (set4) {
                            hostsInInitialization.remove(host);
                            throw throwable;
                        }
                    }
                }
                synchronized (set3) {
                    hostsInInitialization.remove(host);
                    return;
                }
            }
            Class<?> connectorClass = connector.getClass();
            if (!RSE_SSH_CONNECTOR_SERVICE_CLASSNAME.equals(connectorClass.getName())) break block29;
            try {
                Object invoke;
                Method method = connectorClass.getMethod(SSH_CONNECTOR_SERVICE_GETSESSION_METHODNAME, new Class[0]);
                if (method == null || !((invoke = method.invoke((Object)connector, null)) instanceof Session)) break block29;
                Session session = (Session)invoke;
                connection.setPassword(session.getUserInfo().getPassword());
                connection.connect();
                if (!connection.isConnected()) break block29;
                set = hostsInInitialization;
            }
            catch (Exception e) {
                DLTKRSEPlugin.log(e);
            }
            synchronized (set) {
                hostsInInitialization.remove(host);
                return;
            }
        }
        Set<IHost> set = hostsInInitialization;
        synchronized (set) {
            hostsInInitialization.remove(host);
        }
        SystemSignonInformation information = PasswordPersistenceManager.getInstance().find(host.getSystemType(), host.getHostName(), userId);
        if (information != null && information.getPassword() != null) {
            connection.setPassword(information.getPassword());
            connection.connect();
            if (connection.isConnected()) {
                return;
            }
        }
        connection.connect();
        if (connection.isConnected()) {
            return;
        }
        connection.setDisabled(10000);
    }
}

