/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityDLTKExtensionManager {
    public static final String PRIORITY_ATTR = "priority";
    private Map<String, ElementInfo> extensions;
    private final String extensionPoint;
    private final String identifier;
    private Map<String, Integer> prefferedLevels;
    private final Map<String, ElementInfo> prefferedExtensionCache = new HashMap<String, ElementInfo>();

    public PriorityDLTKExtensionManager(String extensionPoint, String identifier) {
        Assert.isNotNull((Object)extensionPoint);
        Assert.isNotNull((Object)identifier);
        this.extensionPoint = extensionPoint;
        this.identifier = identifier;
    }

    protected synchronized Map<String, ElementInfo> initialize() {
        if (this.extensions != null) {
            return this.extensions;
        }
        this.extensions = new HashMap<String, ElementInfo>(5);
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPoint);
        int i = 0;
        while (i < cfg.length) {
            IConfigurationElement element = cfg[i];
            if (this.isValidConfigurationElement(element)) {
                int lev;
                String nature = element.getAttribute(this.identifier);
                ElementInfo oldInfo = this.extensions.get(nature);
                if (oldInfo != null && (lev = this.getLevel(element)) <= oldInfo.level) {
                    ElementInfo e = oldInfo;
                    ElementInfo nInfo = this.createNewInfo(element, null);
                    while (e != null) {
                        if (e.oldInfo == null) {
                            e.oldInfo = nInfo;
                        } else {
                            if (nInfo.level < e.oldInfo.level) {
                                e = e.oldInfo;
                                continue;
                            }
                            nInfo.oldInfo = e.oldInfo;
                            e.oldInfo = nInfo;
                        }
                        break;
                    }
                } else {
                    ElementInfo info = this.createNewInfo(element, oldInfo);
                    this.extensions.put(nature, info);
                }
            }
            ++i;
        }
        return this.extensions;
    }

    protected boolean isValidConfigurationElement(IConfigurationElement element) {
        return true;
    }

    private ElementInfo createNewInfo(IConfigurationElement cfg, ElementInfo oldInfo) {
        ElementInfo info = this.createInfo(cfg);
        info.level = this.getLevel(info.config);
        info.oldInfo = oldInfo;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementInfo internalGetElementInfo(String id) {
        ElementInfo info;
        Map<String, ElementInfo> map = this.prefferedExtensionCache;
        synchronized (map) {
            info = this.prefferedExtensionCache.get(id);
        }
        if (info != null) {
            return info;
        }
        info = this.initialize().get(id);
        if (info != null) {
            Integer level;
            PriorityDLTKExtensionManager priorityDLTKExtensionManager = this;
            synchronized (priorityDLTKExtensionManager) {
                level = this.prefferedLevels != null ? this.prefferedLevels.get(id) : null;
            }
            if (level != null) {
                int prefferedLevel = level;
                ElementInfo o = info;
                do {
                    if (o.level != prefferedLevel) continue;
                    info = o;
                    break;
                } while ((o = o.oldInfo) != null);
            }
            Map<String, ElementInfo> map2 = this.prefferedExtensionCache;
            synchronized (map2) {
                this.prefferedExtensionCache.put(id, info);
            }
        }
        return info;
    }

    protected ElementInfo getElementInfo(String id) {
        return this.internalGetElementInfo(id);
    }

    protected int getLevel(IConfigurationElement config) {
        String priority = config.getAttribute(PRIORITY_ATTR);
        if (priority == null) {
            return 0;
        }
        try {
            int parseInt = Integer.parseInt(priority);
            return parseInt;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public ElementInfo[] getElementInfos() {
        Map<String, ElementInfo> exts = this.initialize();
        String[] keys = exts.keySet().toArray(new String[exts.size()]);
        ElementInfo[] values = new ElementInfo[keys.length];
        int i = 0;
        while (i < keys.length) {
            values[i] = this.getElementInfo(keys[i]);
            ++i;
        }
        return values;
    }

    protected ElementInfo createInfo(IConfigurationElement config) {
        return new ElementInfo(config);
    }

    public String findScriptNature(IProject project) {
        block5: {
            if (project.isAccessible()) break block5;
            return null;
        }
        try {
            String[] natureIds = project.getDescription().getNatureIds();
            int i = 0;
            while (i < natureIds.length) {
                String natureId = natureIds[i];
                if (this.getElementInfo(natureId) != null) {
                    return natureId;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPreffetedLevel(String id, int level) {
        Map<String, ElementInfo> map = this.prefferedExtensionCache;
        synchronized (map) {
            this.prefferedExtensionCache.clear();
        }
        if (level != -1) {
            if (this.prefferedLevels == null) {
                this.prefferedLevels = new HashMap<String, Integer>();
            }
            this.prefferedLevels.put(id, level);
        } else if (this.prefferedLevels != null) {
            this.prefferedLevels.remove(id);
        }
    }

    public static class ElementInfo {
        int level;
        public final IConfigurationElement config;
        public Object object;
        public ElementInfo oldInfo;

        protected ElementInfo(IConfigurationElement config) {
            this.config = config;
        }

        public IConfigurationElement getConfig() {
            return this.config;
        }
    }
}

