/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser.jsdoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.utils.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDocTags
implements Iterable<JSDocTag> {
    public static final JSDocTags EMPTY = new JSDocTags(new JSDocTag[0]);
    private final JSDocTag[] tags;

    public JSDocTags(JSDocTag[] tags) {
        this.tags = tags;
    }

    public List<JSDocTag> list() {
        return Arrays.asList(this.tags);
    }

    public JSDocTag get(String tagName) {
        JSDocTag[] jSDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            JSDocTag tag = jSDocTagArray[n2];
            if (tagName.equals(tag.name())) {
                return tag;
            }
            ++n2;
        }
        return null;
    }

    public JSDocTag get(String[] tagNames) {
        JSDocTag[] jSDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            JSDocTag tag = jSDocTagArray[n2];
            String[] stringArray = tagNames;
            int n3 = tagNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String tagName = stringArray[n4];
                if (tagName.equals(tag.name())) {
                    return tag;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public List<JSDocTag> list(String tagName) {
        List<JSDocTag> result = null;
        JSDocTag[] jSDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            JSDocTag tag = jSDocTagArray[n2];
            if (tagName.equals(tag.name())) {
                if (result == null) {
                    result = new ArrayList<JSDocTag>();
                }
                result.add(tag);
            }
            ++n2;
        }
        return result != null ? result : Collections.emptyList();
    }

    public List<JSDocTag> list(String[] tagNames) {
        List<JSDocTag> result = null;
        JSDocTag[] jSDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            JSDocTag tag = jSDocTagArray[n2];
            String[] stringArray = tagNames;
            int n3 = tagNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String tagName = stringArray[n4];
                if (tagName.equals(tag.name())) {
                    if (result == null) {
                        result = new ArrayList<JSDocTag>();
                    }
                    result.add(tag);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return result != null ? result : Collections.emptyList();
    }

    public int size() {
        return this.tags.length;
    }

    public boolean isEmpty() {
        return this.tags.length == 0;
    }

    public JSDocTag get(int index) {
        return this.tags[index];
    }

    public int count(String tagName) {
        int result = 0;
        JSDocTag[] jSDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            JSDocTag tag = jSDocTagArray[n2];
            if (tagName.equals(tag.name())) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public int count(String[] tagNames) {
        int result = 0;
        JSDocTag[] jSDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            JSDocTag tag = jSDocTagArray[n2];
            String[] stringArray = tagNames;
            int n3 = tagNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String tagName = stringArray[n4];
                if (tagName.equals(tag.name())) {
                    ++result;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        JSDocTag[] jSDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            JSDocTag tag = jSDocTagArray[n2];
            if (!first) {
                sb.append(",\n ");
            } else {
                first = false;
            }
            sb.append(tag);
            ++n2;
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<JSDocTag> iterator() {
        return new ArrayIterator((Object[])this.tags);
    }

    public JSDocTag getTagAt(int offset) {
        JSDocTag[] jSDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            JSDocTag tag = jSDocTagArray[n2];
            if (tag.start() <= offset && tag.end() >= offset) {
                return tag;
            }
            ++n2;
        }
        return null;
    }
}

