/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.Collection;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSNode
extends ASTNode {
    private final JSNode parent;

    protected static void toSourceString(Collection<Statement> statements, StringBuffer buffer, String indentationString) {
        for (Statement statement : statements) {
            buffer.append(statement.toSourceString(indentationString));
        }
    }

    protected static String toSourceString(ISourceable node, String indentationString) {
        return node != null ? node.toSourceString(indentationString) : "?";
    }

    public JSNode(JSNode parent) {
        this.parent = parent;
        this.setStart(0);
        this.setEnd(0);
    }

    public JSNode getParent() {
        return this.parent;
    }

    public Script getScript() {
        JSNode current = this.parent;
        while (!(current instanceof Script)) {
            current = current.parent;
        }
        return (Script)current;
    }

    public <T extends JSNode> T getAncestor(Class<T> clazz) {
        JSNode current = this;
        while (!clazz.isInstance((Object)current)) {
            current = current.parent;
        }
        return (T)((Object)current);
    }

    public Comment getDocumentation() {
        return null;
    }

    public String toString() {
        return this.toSourceString("");
    }

    public abstract String toSourceString(String var1);

    public ISourceRange getRange() {
        return new SourceRange(this.sourceStart(), this.sourceEnd() - this.sourceStart());
    }
}

