/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.IScriptValue;

public class CollectionScriptType
extends AtomicScriptType {
    protected CollectionScriptType(String name) {
        super(name);
    }

    public boolean isAtomic() {
        return false;
    }

    public boolean isCollection() {
        return true;
    }

    public String formatDetails(IScriptValue value) {
        StringBuffer sb = new StringBuffer();
        try {
            IVariable[] variables2 = value.getVariables();
            if (variables2.length > 0) {
                sb.append(this.getOpenBrace());
                int i = 0;
                while (i < variables2.length) {
                    String details = this.buildDetailString(variables2[i]);
                    sb.append(details);
                    sb.append(",");
                    ++i;
                }
                sb.setLength(sb.length() - 1);
                sb.append(this.getCloseBrace());
            }
        }
        catch (DebugException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public String formatValue(IScriptValue value) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        try {
            int size = value instanceof IIndexedValue ? ((IIndexedValue)value).getSize() : value.getVariables().length;
            sb.append("[" + size + "]");
        }
        catch (DebugException debugException) {
            sb.append("[]");
        }
        this.appendInstanceId(value, sb);
        return sb.toString();
    }

    protected String buildDetailString(IVariable variable) throws DebugException {
        return variable.getValue().getValueString();
    }

    protected char getCloseBrace() {
        return ']';
    }

    protected char getOpenBrace() {
        return '[';
    }
}

