/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.ArrayList;
import org.eclipse.dltk.internal.javascript.typeinference.CompletionString;

public class CompletionPath {
    private final Segment[] segments;

    public CompletionPath(String path) {
        String[] tokens;
        String parsed = CompletionString.parse(path, true, true);
        ArrayList<Segment> s = new ArrayList<Segment>();
        String[] stringArray = tokens = parsed.split("\\.", -1);
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            SegmentType type = SegmentType.SIMPLE;
            if (token.equals("[]")) {
                token = null;
                type = SegmentType.ARRAY;
            } else if (token.equals("()")) {
                token = null;
                type = SegmentType.FUNCTION;
            } else if (token.equals("{}")) {
                token = null;
                type = SegmentType.OBJECT;
            }
            s.add(new Segment(token, type));
            ++n2;
        }
        this.segments = s.toArray(new Segment[s.size()]);
    }

    public boolean isEmpty() {
        return this.segments.length == 0;
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public SegmentType segmentType(int index) {
        return this.segments[index].type;
    }

    public String segment(int index) {
        return this.segments[index].name;
    }

    public boolean isName(int index) {
        return this.segments[index].type == SegmentType.SIMPLE;
    }

    public boolean isArray(int index) {
        return this.segments[index].type == SegmentType.ARRAY;
    }

    public boolean isFunction(int index) {
        return this.segments[index].type == SegmentType.FUNCTION;
    }

    public boolean isObject(int index) {
        return this.segments[index].type == SegmentType.OBJECT;
    }

    public String lastSegment() {
        return !this.isEmpty() ? this.segments[this.segments.length - 1].name : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Segment[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            if (sb.length() != 0) {
                sb.append('.');
            }
            if (segment.type == SegmentType.FUNCTION) {
                sb.append("()");
            } else if (segment.type == SegmentType.ARRAY) {
                sb.append("[]");
            } else {
                sb.append(segment.name);
            }
            ++n2;
        }
        return sb.toString();
    }

    private static class Segment {
        final String name;
        final SegmentType type;

        public Segment(String name, SegmentType type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return "Segment[type:" + this.type.toString() + ",name:" + this.name + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SegmentType {
        SIMPLE,
        ARRAY,
        FUNCTION,
        OBJECT;

    }
}

