/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeLiteral;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoModelResourceSet
extends ResourceSetImpl {
    public TypeInfoModelResourceSet() {
        this.setURIResourceMap(new HashMap());
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        if (TypeUtil.isTypeProxy(uri)) {
            String typeName = URI.decode((String)uri.fragment());
            Type type = this.resolveType(typeName);
            if (type != null) {
                return type;
            }
            return null;
        }
        return super.getEObject(uri, loadOnDemand);
    }

    protected Type resolveType(String typeName) {
        return this.getType(typeName, true);
    }

    protected Resource[] resources() {
        EList resources = this.getResources();
        return (Resource[])resources.toArray((Object[])new Resource[resources.size()]);
    }

    public Type getType(String typeName, boolean all) {
        Resource[] resourceArray = this.resources();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            for (EObject object : resource.getContents()) {
                if (!(object instanceof Type)) continue;
                Type type = (Type)object;
                if (!all && !type.isVisible() || !typeName.equals(type.getName())) continue;
                return type;
            }
            ++n2;
        }
        return null;
    }

    public Type getTypeLiteral(String name) {
        Resource[] resourceArray = this.resources();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            for (EObject object : resource.getContents()) {
                String n3;
                TypeLiteral literal;
                Type type;
                if (!(object instanceof TypeLiteral) || (type = (literal = (TypeLiteral)object).getTarget()) == null) continue;
                String string = n3 = literal.getName() != null ? literal.getName() : type.getName();
                if (!name.equals(n3)) continue;
                return type;
            }
            ++n2;
        }
        return null;
    }

    public Set<String> listTypes(String prefix) {
        HashSet<String> result = new HashSet<String>();
        Resource[] resourceArray = this.resources();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            for (EObject object : resource.getContents()) {
                Type type;
                if (!(object instanceof Type) || !(type = (Type)object).isVisible() || !CharOperation.prefixEquals((String)prefix, (String)type.getName())) continue;
                result.add(type.getName());
            }
            ++n2;
        }
        return result;
    }

    public Set<String> listTypeLiterals(String prefix) {
        HashSet<String> result = new HashSet<String>();
        Resource[] resourceArray = this.resources();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            for (EObject object : resource.getContents()) {
                String name;
                TypeLiteral literal;
                Type type;
                if (!(object instanceof TypeLiteral) || (type = (literal = (TypeLiteral)object).getTarget()) == null) continue;
                String string = name = literal.getName() != null ? literal.getName() : type.getName();
                if (!CharOperation.prefixEquals((String)prefix, (String)name)) continue;
                result.add(name);
            }
            ++n2;
        }
        return result;
    }
}

