/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.text.ParseException;
import java.util.ArrayList;
import org.eclipse.dltk.internal.javascript.ti.JSDocSupport;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.internal.ui.text.TypeNameNode;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParser;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParserExtension;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;

public class JSDocTypeUtil {
    public static JSDocTypeParser createTypeParser(TypeInferencer2 inferencer) {
        IModelBuilder[] iModelBuilderArray = inferencer.getModelBuilders();
        int n = iModelBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder builder = iModelBuilderArray[n2];
            if (builder instanceof JSDocSupport) {
                return ((JSDocSupport)builder).createTypeParser();
            }
            ++n2;
        }
        return null;
    }

    public static TypeNameNode findName(TypeInferencer2 inferencer2, String typeExpression, int offsetInTypeExpression) {
        JSDocTypeParser typeParser = JSDocTypeUtil.createTypeParser(inferencer2);
        if (typeParser == null) {
            return null;
        }
        final ArrayList typeNames = new ArrayList();
        typeParser.setExtension(new JSDocTypeParserExtension(){

            public void reportType(JSType type, int s, int e) {
                if (type instanceof SimpleType) {
                    typeNames.add(new TypeNameNode(((SimpleType)type).getTarget().getName(), s, e));
                }
            }
        });
        try {
            typeParser.parse(typeExpression);
        }
        catch (ParseException parseException) {
            return null;
        }
        for (TypeNameNode range : typeNames) {
            if (range.start > offsetInTypeExpression || offsetInTypeExpression >= range.end) continue;
            return range;
        }
        return null;
    }
}

