/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.quickfix;

import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.quickfix.TextFileEditResolution;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class GenerateSuppressWarningsResolution
extends TextFileEditResolution {
    private final String type;

    public GenerateSuppressWarningsResolution(IFile scriptFile, int problemStartIdx, String type) {
        super(scriptFile, problemStartIdx);
        this.type = type;
    }

    public String getLabel() {
        FunctionStatement fs = this.getFunctionStatement(this.getScriptFile(), this.getProblemStartIdx());
        if (fs != null) {
            return "Add SuppressWarnings(" + this.type + ") to '" + this.getFunctionStatement(this.getScriptFile(), this.getProblemStartIdx()).getFunctionName() + "'";
        }
        return "Add SuppressWarnings(" + this.type + ")";
    }

    public Image getImage() {
        return DLTKPluginImages.getImage((AbstractUIPlugin)JavaScriptUI.getDefault(), (String)"icons/obj16/supresswarnings.gif");
    }

    protected MultiTextEdit getTextEdit(IFile scriptFile, int position) {
        MultiTextEdit textEdit = new MultiTextEdit();
        FunctionStatement fs = this.getFunctionStatement(scriptFile, position);
        if (fs != null) {
            int insertOffset = -1;
            Comment documentation = fs.getDocumentation();
            if (documentation != null && documentation.isDocumentation()) {
                insertOffset = documentation.sourceEnd() - 2;
                InsertEdit suppressTextEdit = new InsertEdit(insertOffset, "* " + this.getAnnotation() + "\n ");
                textEdit.addChild((TextEdit)suppressTextEdit);
            } else {
                textEdit.addChild((TextEdit)new InsertEdit(fs.sourceStart(), "/**\n * " + this.getAnnotation() + "\n*/\n"));
            }
        }
        return textEdit;
    }

    private FunctionStatement getFunctionStatement(IFile scriptFile, final int position) {
        Script script = JavaScriptParserUtil.parse((ISourceModule)DLTKCore.createSourceModuleFrom((IFile)scriptFile));
        final ASTNode[] closestValue = new ASTNode[1];
        ASTVisitor finder = new ASTVisitor(){

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (node.sourceStart() > position) {
                    return false;
                }
                if (node.sourceEnd() >= position) {
                    closestValue[0] = node;
                }
                return true;
            }
        };
        try {
            script.traverse(finder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ASTNode node = closestValue[0];
        while (node instanceof JSNode) {
            if (node instanceof FunctionStatement) {
                return (FunctionStatement)node;
            }
            node = ((JSNode)node).getParent();
        }
        return null;
    }

    public String getDescription() {
        FunctionStatement f = this.getFunctionStatement(this.getScriptFile(), this.getProblemStartIdx());
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.getScriptFile());
        try {
            String functionString = sourceModule.getBuffer().getText(f.sourceStart(), f.sourceEnd() - f.sourceStart());
            int lineEnd = functionString.indexOf(10);
            StringBuilder sb = new StringBuilder(lineEnd + 100);
            sb.append("<html><body> *<b>");
            sb.append(this.getAnnotation());
            sb.append("</b><br/> */<br/>");
            sb.append(functionString.substring(0, lineEnd));
            sb.append("</body></html>");
            return sb.toString();
        }
        catch (ModelException modelException) {
            return this.getLabel();
        }
    }

    private String getAnnotation() {
        return "@SuppressWarnings(" + this.type + ")";
    }

    public boolean isValid() {
        return this.getFunctionStatement(this.getScriptFile(), this.getProblemStartIdx()) != null;
    }
}

