/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.caching.AbstractDataLoader;
import org.eclipse.dltk.core.caching.IStructureConstants;

public class StructureModelProcessor
extends AbstractDataLoader
implements IStructureConstants {
    private ISourceElementRequestor requestor;

    public StructureModelProcessor(InputStream stream, ISourceElementRequestor requestor) {
        super(stream);
        this.requestor = requestor;
    }

    public void perform() throws IOException {
        this.readStrings();
        this.readData();
    }

    private void readData() {
        try {
            while (true) {
                int tag = this.in.readInt();
                switch (tag) {
                    case 0: {
                        this.acceptFieldReference();
                        break;
                    }
                    case 1: {
                        this.acceptMethodReference();
                        break;
                    }
                    case 2: {
                        this.acceptPackage();
                        break;
                    }
                    case 3: {
                        this.acceptTypeReference1();
                        break;
                    }
                    case 4: {
                        this.acceptTypeReference2();
                        break;
                    }
                    case 5: {
                        this.enterField();
                        break;
                    }
                    case 23: {
                        this.updateField();
                        break;
                    }
                    case 6: {
                        this.enterFieldCheckDuplicates();
                        break;
                    }
                    case 7: {
                        this.enterFieldWithParentType();
                        break;
                    }
                    case 8: {
                        this.enterMethod();
                        break;
                    }
                    case 9: {
                        this.enterMethodRemoveSame();
                        break;
                    }
                    case 10: {
                        this.enterMethodWithParentType();
                        break;
                    }
                    case 11: {
                        this.enterModule();
                        break;
                    }
                    case 12: {
                        this.enterModuleRoot();
                        break;
                    }
                    case 13: {
                        this.enterType();
                        break;
                    }
                    case 14: {
                        this.enterTypeAppend();
                        break;
                    }
                    case 15: {
                        this.exitField();
                        break;
                    }
                    case 16: {
                        this.exitMethod();
                        break;
                    }
                    case 17: {
                        this.exitModule();
                        break;
                    }
                    case 18: {
                        this.exitModuleRoot();
                        break;
                    }
                    case 19: {
                        this.exitType();
                        break;
                    }
                    case 20: {
                        this.acceptImport();
                    }
                }
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {}
    }

    private char[] readDataString() throws IOException {
        String text = this.readString();
        if (text == null) {
            return null;
        }
        return text.toCharArray();
    }

    private char[][] readDataStrings() throws IOException {
        int size = this.in.readInt();
        if (size == 0) {
            return null;
        }
        char[][] result = new char[size][];
        int i = 0;
        while (i < size) {
            result[i] = this.readDataString();
            ++i;
        }
        return result;
    }

    private String[] readDataStringsStr() throws IOException {
        int size = this.in.readInt();
        if (size == 0) {
            return null;
        }
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = this.readString();
            ++i;
        }
        return result;
    }

    public void acceptFieldReference() {
        try {
            String fieldName = this.readString();
            int sourcePosition = this.in.readInt();
            this.requestor.acceptFieldReference(fieldName, sourcePosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptMethodReference() {
        try {
            String methodName = this.readString();
            int argCount = this.in.readInt();
            int sourcePosition = this.in.readInt();
            int sourceEndPosition = this.in.readInt();
            this.requestor.acceptMethodReference(methodName, argCount, sourcePosition, sourceEndPosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptPackage() {
        try {
            String name = this.readString();
            int declarationStart = this.in.readInt();
            int declarationEnd = this.in.readInt();
            this.requestor.acceptPackage(declarationStart, declarationEnd, name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void acceptTypeReference1() {
        try {
            this.readDataStrings();
            this.in.readInt();
            this.in.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptTypeReference2() {
        try {
            String typeName = this.readString();
            int sourcePosition = this.in.readInt();
            this.requestor.acceptTypeReference(typeName, sourcePosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterField() {
        try {
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            this.readFieldInfo(info);
            this.requestor.enterField(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateField() {
        try {
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            this.readFieldInfo(info);
            this.requestor.updateField(info, this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readFieldInfo(IElementRequestor.FieldInfo info) throws IOException {
        this.readElementInfo(info);
    }

    private void readMethodInfo(IElementRequestor.MethodInfo info) throws IOException {
        this.readElementInfo(info);
        info.parameterNames = this.readDataStringsStr();
        info.parameterInitializers = this.readDataStringsStr();
        info.exceptionTypes = this.readDataStringsStr();
        info.isConstructor = this.in.readBoolean();
    }

    private void readTypeInfo(IElementRequestor.TypeInfo info) throws IOException {
        this.readElementInfo(info);
        info.superclasses = this.readDataStringsStr();
    }

    private void readElementInfo(IElementRequestor.ElementInfo info) throws IOException {
        info.name = this.readString();
        info.modifiers = this.in.readInt();
        info.nameSourceStart = this.in.readInt();
        info.nameSourceEnd = this.in.readInt();
        info.declarationStart = this.in.readInt();
    }

    public boolean enterFieldCheckDuplicates() {
        try {
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            this.readFieldInfo(info);
            boolean result = this.in.readBoolean();
            this.requestor.enterFieldCheckDuplicates(info);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean enterFieldWithParentType() {
        boolean result = false;
        try {
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            this.readFieldInfo(info);
            this.readString();
            this.readString();
            this.in.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void enterMethod() {
        try {
            IElementRequestor.MethodInfo info = new IElementRequestor.MethodInfo();
            this.readMethodInfo(info);
            this.requestor.enterMethod(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterMethodRemoveSame() {
        try {
            IElementRequestor.MethodInfo info = new IElementRequestor.MethodInfo();
            this.readMethodInfo(info);
            this.requestor.enterMethodRemoveSame(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean enterMethodWithParentType() {
        boolean result = false;
        try {
            IElementRequestor.MethodInfo info = new IElementRequestor.MethodInfo();
            this.readMethodInfo(info);
            this.readString();
            this.readString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void enterModule() {
        this.requestor.enterModule();
    }

    public void enterModuleRoot() {
        this.requestor.enterModuleRoot();
    }

    public void enterType() {
        try {
            IElementRequestor.TypeInfo info = new IElementRequestor.TypeInfo();
            this.readTypeInfo(info);
            this.requestor.enterType(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean enterTypeAppend() {
        try {
            String fullName = this.readString();
            String delimiter = this.readString();
            return this.requestor.enterTypeAppend(fullName, delimiter);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void exitField() {
        try {
            this.requestor.exitField(this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitMethod() {
        try {
            this.requestor.exitMethod(this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitModule() {
        try {
            this.requestor.exitModule(this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitModuleRoot() {
        this.requestor.exitModuleRoot();
    }

    public void exitType() {
        try {
            this.requestor.exitType(this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void acceptImport() {
        try {
            IElementRequestor.ImportInfo importInfo = new IElementRequestor.ImportInfo();
            importInfo.sourceStart = this.in.readInt();
            importInfo.sourceEnd = this.in.readInt();
            importInfo.containerName = this.readString();
            importInfo.name = this.readString();
            importInfo.version = this.readString();
            this.requestor.acceptImport(importInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

