/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IValidationStatus;

public class ValidationStatus
implements IValidationStatus {
    private final IProblemIdentifier identifier;
    private final String message;
    private final int start;
    private final int end;

    public ValidationStatus(IProblemIdentifier identifier, String message) {
        this(identifier, message, -1, -1);
    }

    public ValidationStatus(IProblemIdentifier identifier, String message, int start, int end) {
        this.identifier = identifier;
        this.message = message;
        this.start = start;
        this.end = end;
    }

    public IProblemIdentifier identifier() {
        return this.identifier;
    }

    public String message() {
        return this.message;
    }

    public String toString() {
        return this.identifier + " " + this.message;
    }

    public boolean hasRange() {
        return this.start >= 0 && this.end >= 0;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }
}

