/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchyBuilders;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.text.AbstractInformationControl;
import org.eclipse.dltk.internal.ui.text.TextMessages;
import org.eclipse.dltk.internal.ui.typehierarchy.AbstractHierarchyViewerSorter;
import org.eclipse.dltk.internal.ui.util.StringMatcher;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ProblemsLabelDecorator;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.MemberFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public class ScriptOutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter fKeyAdapter;
    private OutlineContentProvider fOutlineContentProvider;
    private IModelElement fInput = null;
    private OutlineSorter fOutlineSorter;
    private OutlineLabelProvider fInnerLabelProvider;
    protected Color fForegroundColor;
    private boolean fShowOnlyMainType;
    private LexicalSortingAction fLexicalSortingAction;
    private SortByDefiningTypeAction fSortByDefiningTypeAction;
    protected Map<IType, ITypeHierarchy> fTypeHierarchies = new HashMap<IType, ITypeHierarchy>();
    private final IPreferenceStore fPreferenceStore;
    private String fPattern;

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    @Deprecated
    public ScriptOutlineInformationControl(Shell parent, int shellStyle, int treeStyle, String commandId) {
        this(parent, shellStyle, treeStyle, commandId, DLTKUIPlugin.getDefault().getPreferenceStore());
    }

    public ScriptOutlineInformationControl(Shell parent, int shellStyle, int treeStyle, String commandId, IPreferenceStore preferenceStore) {
        super(parent, shellStyle, treeStyle, commandId, true);
        this.fPreferenceStore = preferenceStore;
        this.create();
    }

    protected final boolean isEarlyCreate() {
        return false;
    }

    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        OutlineTreeViewer treeViewer = new OutlineTreeViewer(tree);
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter(this));
        treeViewer.addFilter(new MemberFilter());
        this.fForegroundColor = parent.getDisplay().getSystemColor(16);
        this.fInnerLabelProvider = new OutlineLabelProvider();
        this.fInnerLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        treeViewer.setLabelProvider((IBaseLabelProvider)this.fInnerLabelProvider);
        this.fLexicalSortingAction = new LexicalSortingAction(treeViewer);
        this.fSortByDefiningTypeAction = new SortByDefiningTypeAction(treeViewer);
        this.fOutlineContentProvider = new OutlineContentProvider(false);
        treeViewer.setContentProvider((IContentProvider)this.fOutlineContentProvider);
        this.fOutlineSorter = new OutlineSorter();
        treeViewer.setSorter(this.fOutlineSorter);
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    protected String getStatusFieldText() {
        KeySequence[] sequences = this.getInvokingCommandKeySequences();
        if (sequences == null || sequences.length == 0) {
            return "";
        }
        String keySequence = sequences[0].format();
        if (this.fOutlineContentProvider.isShowingInheritedMembers()) {
            return Messages.format(TextMessages.ScriptOutlineInformationControl_pressToHideInheritedMembers, keySequence);
        }
        return Messages.format(TextMessages.ScriptOutlineInformationControl_pressToShowInheritedMembers, keySequence);
    }

    protected String getId() {
        return "org.eclipse.dltk.internal.ui.text.QuickOutline";
    }

    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        IModelElement je = (IModelElement)information;
        ISourceModule cu = (ISourceModule)je.getAncestor(5);
        if (cu != null) {
            this.fInput = cu;
        }
        this.inputChanged(this.fInput, information);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    KeySequence[] sequences = ScriptOutlineInformationControl.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            ScriptOutlineInformationControl.this.toggleShowInheritedMembers();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected void handleStatusFieldClicked() {
        this.toggleShowInheritedMembers();
    }

    protected void toggleShowInheritedMembers() {
        long flags = this.fInnerLabelProvider.getTextFlags();
        this.fInnerLabelProvider.setTextFlags(flags ^= ScriptElementLabels.ALL_POST_QUALIFIED);
        this.fOutlineContentProvider.toggleShowInheritedMembers();
        this.updateStatusFieldText();
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
    }

    protected void setMatcherString(String pattern, boolean update) {
        this.fPattern = pattern;
        if (pattern.length() == 0 || !this.fSortByDefiningTypeAction.isChecked()) {
            super.setMatcherString(pattern, update);
            return;
        }
        boolean ignoreCase = pattern.toLowerCase().equals(pattern);
        String pattern2 = "* - " + pattern;
        this.fStringMatcher = new OrStringMatcher(pattern, pattern2, ignoreCase, false);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    protected ITypeHierarchy getSuperTypeHierarchy(IType type) {
        ITypeHierarchy th = this.fTypeHierarchies.get(type);
        if (th == null) {
            try {
                th = TypeHierarchyBuilders.getTypeHierarchy((IType)type, (ITypeHierarchy.Mode)ITypeHierarchy.Mode.SUPERTYPE, (IProgressMonitor)this.getProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            this.fTypeHierarchies.put(type, th);
        }
        return th;
    }

    protected IProgressMonitor getProgressMonitor() {
        IWorkbenchPage wbPage = DLTKUIPlugin.getActivePage();
        if (wbPage == null) {
            return null;
        }
        IEditorPart editor = wbPage.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    protected boolean isInnerType(IModelElement element) {
        if (element != null && element.getElementType() == 7) {
            IType type = (IType)element;
            return type.getDeclaringType() != null;
        }
        return false;
    }

    private class LexicalSortingAction
    extends Action {
        private static final String STORE_LEXICAL_SORTING_CHECKED = "LexicalSortingAction.isChecked";
        private TreeViewer fOutlineViewer;

        private LexicalSortingAction(TreeViewer outlineViewer) {
            super(TextMessages.ScriptOutlineInformationControl_LexicalSortingAction_label, 2);
            this.setToolTipText(TextMessages.ScriptOutlineInformationControl_LexicalSortingAction_tooltip);
            this.setDescription(TextMessages.ScriptOutlineInformationControl_LexicalSortingAction_description);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.fOutlineViewer = outlineViewer;
            boolean checked = ScriptOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_LEXICAL_SORTING_CHECKED);
            this.setChecked(checked);
            if (DLTKUIPlugin.isDebug()) {
                System.err.println("TODO: add help support here");
            }
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    LexicalSortingAction.this.fOutlineViewer.refresh(false);
                }
            });
            if (store) {
                ScriptOutlineInformationControl.this.getDialogSettings().put(STORE_LEXICAL_SORTING_CHECKED, on);
            }
        }
    }

    private static class OrStringMatcher
    extends StringMatcher {
        private StringMatcher fMatcher1;
        private StringMatcher fMatcher2;

        private OrStringMatcher(String pattern1, String pattern2, boolean ignoreCase, boolean foo) {
            super("", false, false);
            this.fMatcher1 = new StringMatcher(pattern1, ignoreCase, false);
            this.fMatcher2 = new StringMatcher(pattern2, ignoreCase, false);
        }

        public boolean match(String text) {
            return this.fMatcher2.match(text) || this.fMatcher1.match(text);
        }
    }

    private class OutlineContentProvider
    extends StandardModelElementContentProvider {
        private boolean fShowInheritedMembers;

        private OutlineContentProvider(boolean showInheritedMembers) {
            super(true);
            this.fShowInheritedMembers = showInheritedMembers;
        }

        public boolean isShowingInheritedMembers() {
            return this.fShowInheritedMembers;
        }

        public void toggleShowInheritedMembers() {
            Tree tree = ScriptOutlineInformationControl.this.getTreeViewer().getTree();
            tree.setRedraw(false);
            this.fShowInheritedMembers = !this.fShowInheritedMembers;
            ScriptOutlineInformationControl.this.getTreeViewer().refresh();
            ScriptOutlineInformationControl.this.getTreeViewer().expandToLevel(2);
            Object selectedElement = ScriptOutlineInformationControl.this.getSelectedElement();
            if (selectedElement != null) {
                ScriptOutlineInformationControl.this.getTreeViewer().reveal(selectedElement);
            }
            tree.setRedraw(true);
        }

        public Object[] getChildren(Object element) {
            ITypeHierarchy th;
            IType type;
            if (this.fShowInheritedMembers && element instanceof IType && !ScriptOutlineInformationControl.this.isInnerType((IModelElement)(type = (IType)element)) && (th = ScriptOutlineInformationControl.this.getSuperTypeHierarchy(type)) != null) {
                ArrayList children = new ArrayList();
                Collections.addAll(children, super.getChildren(type));
                IType[] superClasses = th.getAllSupertypes(type);
                int i = 0;
                int scLength = superClasses.length;
                while (i < scLength) {
                    Collections.addAll(children, super.getChildren(superClasses[i]));
                    ++i;
                }
                return children.toArray();
            }
            return super.getChildren(element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
            ScriptOutlineInformationControl.this.fTypeHierarchies.clear();
        }

        public void dispose() {
            super.dispose();
            ScriptOutlineInformationControl.this.fTypeHierarchies.clear();
        }
    }

    private class OutlineLabelProvider
    extends AppearanceAwareLabelProvider {
        private boolean fShowDefiningType;

        private OutlineLabelProvider() {
            super(0x2010000004029L | ScriptElementLabels.ALL_CATEGORY, 1, ScriptOutlineInformationControl.this.getPreferenceStore());
        }

        public String getText(Object element) {
            String text = super.getText(element);
            if (this.fShowDefiningType) {
                try {
                    IType type = this.getDefiningType(element);
                    if (type != null) {
                        StringBuffer buf = new StringBuffer(super.getText(type));
                        buf.append(" - ");
                        buf.append(text);
                        return buf.toString();
                    }
                }
                catch (ModelException modelException) {}
            }
            return text;
        }

        public Color getForeground(Object element) {
            if (ScriptOutlineInformationControl.this.fOutlineContentProvider.isShowingInheritedMembers()) {
                if (element instanceof IModelElement) {
                    IModelElement je = (IModelElement)element;
                    je = je.getAncestor(5);
                    if (ScriptOutlineInformationControl.this.fInput.equals(je)) {
                        return null;
                    }
                }
                return ScriptOutlineInformationControl.this.fForegroundColor;
            }
            return null;
        }

        public void setShowDefiningType(boolean showDefiningType) {
            this.fShowDefiningType = showDefiningType;
        }

        public boolean isShowDefiningType() {
            return this.fShowDefiningType;
        }

        private IType getDefiningType(Object element) throws ModelException {
            int kind = ((IModelElement)element).getElementType();
            if (kind != 9 && kind != 8) {
                return null;
            }
            IType declaringType = ((IMember)element).getDeclaringType();
            if (kind != 9) {
                return declaringType;
            }
            ITypeHierarchy hierarchy = ScriptOutlineInformationControl.this.getSuperTypeHierarchy(declaringType);
            if (hierarchy == null) {
                return declaringType;
            }
            IMethod method = (IMethod)element;
            return method.getDeclaringType();
        }
    }

    private class OutlineSorter
    extends AbstractHierarchyViewerSorter {
        private OutlineSorter() {
        }

        protected ITypeHierarchy getHierarchy(IType type) {
            return ScriptOutlineInformationControl.this.getSuperTypeHierarchy(type);
        }

        public boolean isSortByDefiningType() {
            return ScriptOutlineInformationControl.this.fSortByDefiningTypeAction.isChecked();
        }

        public boolean isSortAlphabetically() {
            return ScriptOutlineInformationControl.this.fLexicalSortingAction.isChecked();
        }
    }

    private class OutlineTreeViewer
    extends TreeViewer {
        private boolean fIsFiltering;

        private OutlineTreeViewer(Tree tree) {
            super(tree);
            this.fIsFiltering = false;
        }

        protected Object[] getFilteredChildren(Object parent) {
            Object[] result = this.getRawChildren(parent);
            int unfilteredChildren = result.length;
            ViewerFilter[] filters = this.getFilters();
            if (filters != null) {
                int i = 0;
                while (i < filters.length) {
                    result = filters[i].filter((Viewer)this, parent, result);
                    ++i;
                }
            }
            this.fIsFiltering = unfilteredChildren != result.length;
            return result;
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IModelElement je;
            Item i;
            if (!this.fIsFiltering && node instanceof Item && (i = (Item)node).getData() instanceof IModelElement && ((je = (IModelElement)i.getData()).getElementType() == 11 || je.getElementType() == 9 && !this.expandMethodChildren((IMethod)je) || ScriptOutlineInformationControl.this.isInnerType(je))) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean expandMethodChildren(IMethod method) {
            try {
                IModelElement[] iModelElementArray = method.getChildren();
                int n = iModelElementArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IModelElement child = iModelElementArray[n2];
                    if (child.getElementType() != 8) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (ModelException modelException) {}
            return false;
        }
    }

    private class SortByDefiningTypeAction
    extends Action {
        private static final String STORE_SORT_BY_DEFINING_TYPE_CHECKED = "SortByDefiningType.isChecked";
        private TreeViewer fOutlineViewer;

        private SortByDefiningTypeAction(TreeViewer outlineViewer) {
            super(TextMessages.ScriptOutlineInformationControl_SortByDefiningTypeAction_label);
            this.setDescription(TextMessages.ScriptOutlineInformationControl_SortByDefiningTypeAction_description);
            this.setToolTipText(TextMessages.ScriptOutlineInformationControl_SortByDefiningTypeAction_tooltip);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, "definingtype_sort_co.gif");
            this.fOutlineViewer = outlineViewer;
            if (DLTKUIPlugin.isDebug()) {
                System.err.println("TODO: add help support here");
            }
            boolean state = ScriptOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_SORT_BY_DEFINING_TYPE_CHECKED);
            this.setChecked(state);
            ScriptOutlineInformationControl.this.fInnerLabelProvider.setShowDefiningType(state);
        }

        public void run() {
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ScriptOutlineInformationControl.this.fInnerLabelProvider.setShowDefiningType(SortByDefiningTypeAction.this.isChecked());
                    ScriptOutlineInformationControl.this.getDialogSettings().put(SortByDefiningTypeAction.STORE_SORT_BY_DEFINING_TYPE_CHECKED, SortByDefiningTypeAction.this.isChecked());
                    ScriptOutlineInformationControl.this.setMatcherString(ScriptOutlineInformationControl.this.fPattern, false);
                    SortByDefiningTypeAction.this.fOutlineViewer.refresh(true);
                    Object selectedElement = ScriptOutlineInformationControl.this.getSelectedElement();
                    if (selectedElement != null) {
                        SortByDefiningTypeAction.this.fOutlineViewer.reveal(selectedElement);
                    }
                }
            });
        }
    }
}

