/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.BlockFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.BranchFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.ConditionalFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowContext;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.ForInFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.GenericConditionalFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.IfFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.LocalFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.MessageSendFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.ReturnFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.SwitchFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.ThrowFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.TryFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.VariableBinding;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.WhileFlowInfo;
import org.eclipse.dltk.javascript.core.dom.ArrayAccessExpression;
import org.eclipse.dltk.javascript.core.dom.ArrayLiteral;
import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.BinaryOperator;
import org.eclipse.dltk.javascript.core.dom.BlockStatement;
import org.eclipse.dltk.javascript.core.dom.BreakStatement;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.CatchClause;
import org.eclipse.dltk.javascript.core.dom.ConditionalExpression;
import org.eclipse.dltk.javascript.core.dom.ConstStatement;
import org.eclipse.dltk.javascript.core.dom.ContinueStatement;
import org.eclipse.dltk.javascript.core.dom.DefaultClause;
import org.eclipse.dltk.javascript.core.dom.DoStatement;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.ExpressionStatement;
import org.eclipse.dltk.javascript.core.dom.ForEachInStatement;
import org.eclipse.dltk.javascript.core.dom.ForInStatement;
import org.eclipse.dltk.javascript.core.dom.ForStatement;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.GetterAssignment;
import org.eclipse.dltk.javascript.core.dom.IfStatement;
import org.eclipse.dltk.javascript.core.dom.Label;
import org.eclipse.dltk.javascript.core.dom.LabeledStatement;
import org.eclipse.dltk.javascript.core.dom.NewExpression;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.ObjectLiteral;
import org.eclipse.dltk.javascript.core.dom.ParenthesizedExpression;
import org.eclipse.dltk.javascript.core.dom.PropertyAccessExpression;
import org.eclipse.dltk.javascript.core.dom.ReturnStatement;
import org.eclipse.dltk.javascript.core.dom.SetterAssignment;
import org.eclipse.dltk.javascript.core.dom.SimplePropertyAssignment;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.SwitchElement;
import org.eclipse.dltk.javascript.core.dom.SwitchStatement;
import org.eclipse.dltk.javascript.core.dom.ThrowStatement;
import org.eclipse.dltk.javascript.core.dom.TryStatement;
import org.eclipse.dltk.javascript.core.dom.UnaryExpression;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.VariableStatement;
import org.eclipse.dltk.javascript.core.dom.WhileStatement;
import org.eclipse.dltk.javascript.core.dom.rewrite.RefactoringUtils;
import org.eclipse.dltk.javascript.core.dom.util.DomSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FlowAnalyzer
extends DomSwitch<Boolean> {
    private Map<Node, FlowInfo> fData = new HashMap<Node, FlowInfo>(100);
    private GenericConditionalFlowInfo callInfo = this.createGenericConditional();
    public GenericConditionalFlowInfo closureInfo = this.createGenericConditional();
    FlowContext fFlowContext;

    public FlowAnalyzer(FlowContext context) {
        this.fFlowContext = context;
        this.callInfo.mergeEmptyCondition(context);
    }

    protected abstract boolean createReturnFlowInfo(ReturnStatement var1);

    protected abstract boolean isTraverseNeeded(Node var1);

    protected ReturnFlowInfo createReturn(ReturnStatement statement) {
        return new ReturnFlowInfo(statement);
    }

    protected ThrowFlowInfo createThrow() {
        return new ThrowFlowInfo();
    }

    protected BranchFlowInfo createBranch(Label label) {
        return new BranchFlowInfo(label, this.fFlowContext);
    }

    protected GenericSequentialFlowInfo createSequential() {
        return new GenericSequentialFlowInfo();
    }

    protected GenericConditionalFlowInfo createGenericConditional() {
        return new GenericConditionalFlowInfo();
    }

    protected ConditionalFlowInfo createConditional() {
        return new ConditionalFlowInfo();
    }

    protected ForInFlowInfo createForIn() {
        return new ForInFlowInfo();
    }

    protected ForFlowInfo createFor() {
        return new ForFlowInfo();
    }

    protected TryFlowInfo createTry() {
        return new TryFlowInfo();
    }

    protected WhileFlowInfo createWhile() {
        return new WhileFlowInfo();
    }

    protected IfFlowInfo createIf() {
        return new IfFlowInfo();
    }

    protected DoWhileFlowInfo createDoWhile() {
        return new DoWhileFlowInfo();
    }

    protected SwitchFlowInfo createSwitch() {
        return new SwitchFlowInfo();
    }

    protected BlockFlowInfo createBlock() {
        return new BlockFlowInfo();
    }

    protected MessageSendFlowInfo createMessageSendFlowInfo() {
        return new MessageSendFlowInfo();
    }

    protected FlowContext getFlowContext() {
        return this.fFlowContext;
    }

    protected FlowInfo getFlowInfo(Node node) {
        return this.fData.remove(node);
    }

    protected void setFlowInfo(Node node, FlowInfo info) {
        this.fData.put(node, info);
    }

    protected FlowInfo assignFlowInfo(Node target, Node source) {
        FlowInfo result = this.getFlowInfo(source);
        this.setFlowInfo(target, result);
        return result;
    }

    protected FlowInfo accessFlowInfo(Node node) {
        return this.fData.get(node);
    }

    protected GenericSequentialFlowInfo processSequential(Node parent, List<? extends Node> nodes) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        this.process(result, nodes);
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(Node parent, Node node1) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(Node parent, Node node1, Node node2) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            result.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(Node parent) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.setFlowInfo(parent, result);
        return result;
    }

    protected void process(GenericSequentialFlowInfo info, List<? extends Node> nodes) {
        if (nodes == null) {
            return;
        }
        for (Node node : nodes) {
            info.merge(this.getFlowInfo(node), this.fFlowContext);
        }
    }

    protected SwitchData createSwitchData(SwitchStatement node) {
        SwitchData result = new SwitchData();
        EList<SwitchElement> elements = node.getElements();
        if (elements.isEmpty()) {
            return result;
        }
        int start = -1;
        int end = -1;
        FlowInfo info = null;
        for (SwitchElement switchCase : elements) {
            if (switchCase instanceof DefaultClause) {
                result.setHasDefaultCase();
            }
            if (info == null) {
                info = this.createSequential();
                start = switchCase.getBegin();
            } else if (info.isReturn() || info.isPartialReturn() || info.branches()) {
                result.add((IRegion)new Region(start, end - start), info);
                info = this.createSequential();
                start = switchCase.getBegin();
            }
            for (Statement element : switchCase.getStatements()) {
                ((GenericSequentialFlowInfo)info).merge(this.getFlowInfo(element), this.fFlowContext);
            }
            end = switchCase.getEnd();
        }
        result.add((IRegion)new Region(start, end - start), info);
        return result;
    }

    protected void caseSwitchStatement(SwitchStatement node, SwitchData data) {
        SwitchFlowInfo switchFlowInfo = this.createSwitch();
        this.setFlowInfo(node, switchFlowInfo);
        switchFlowInfo.mergeTest(this.getFlowInfo(node.getSelector()), this.fFlowContext);
        FlowInfo[] cases = data.getInfos();
        int i = 0;
        while (i < cases.length) {
            switchFlowInfo.mergeCase(cases[i], this.fFlowContext);
            ++i;
        }
        switchFlowInfo.mergeDefault(data.hasDefaultCase(), this.fFlowContext);
        switchFlowInfo.removeLabel(null);
    }

    protected void traverse(Node node) {
        if (this.isTraverseNeeded(node)) {
            for (EObject obj : node.eContents()) {
                this.traverse((Node)obj);
            }
            this.doSwitch(node);
        }
    }

    @Override
    public Boolean caseArrayAccessExpression(ArrayAccessExpression node) {
        this.processSequential(node, node.getArray(), node.getIndex());
        return true;
    }

    @Override
    public Boolean caseArrayLiteral(ArrayLiteral node) {
        this.processSequential((Node)node, (List<? extends Node>)node.getElements());
        return true;
    }

    @Override
    public Boolean caseObjectLiteral(ObjectLiteral node) {
        this.processSequential((Node)node, (List<? extends Node>)node.getProperties());
        return true;
    }

    @Override
    public Boolean caseBlockStatement(BlockStatement node) {
        BlockFlowInfo info = this.createBlock();
        this.setFlowInfo(node, info);
        this.process(info, (List<? extends Node>)node.getStatements());
        return true;
    }

    @Override
    public Boolean caseBreakStatement(BreakStatement node) {
        this.setFlowInfo(node, this.createBranch(node.getLabel()));
        return true;
    }

    @Override
    public Boolean caseCatchClause(CatchClause node) {
        this.processSequential(node, node.getException(), node.getBody());
        return true;
    }

    @Override
    public Boolean caseNewExpression(NewExpression node) {
        GenericSequentialFlowInfo info = this.processSequential((Node)node, node.getConstructor());
        this.process(info, (List<? extends Node>)node.getArguments());
        return true;
    }

    @Override
    public Boolean caseSource(Source node) {
        this.processSequential((Node)node, (List<? extends Node>)node.getStatements());
        return true;
    }

    @Override
    public Boolean caseConditionalExpression(ConditionalExpression node) {
        ConditionalFlowInfo info = this.createConditional();
        this.setFlowInfo(node, info);
        info.mergeCondition(this.getFlowInfo(node.getPredicate()), this.fFlowContext);
        info.merge(this.getFlowInfo(node.getConsequent()), this.getFlowInfo(node.getAlternative()), this.fFlowContext);
        return true;
    }

    @Override
    public Boolean caseContinueStatement(ContinueStatement node) {
        this.setFlowInfo(node, this.createBranch(node.getLabel()));
        return true;
    }

    @Override
    public Boolean caseDoStatement(DoStatement node) {
        DoWhileFlowInfo info = this.createDoWhile();
        this.setFlowInfo(node, info);
        info.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        info.mergeCondition(this.getFlowInfo(node.getCondition()), this.fFlowContext);
        info.removeLabel(null);
        return true;
    }

    @Override
    public Boolean caseForInStatement(ForInStatement node) {
        ForInFlowInfo forInfo = this.createForIn();
        this.setFlowInfo(node, forInfo);
        forInfo.mergeParameter(this.getFlowInfo(node.getItem()), this.fFlowContext);
        forInfo.mergeExpression(this.getFlowInfo(node.getCollection()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        forInfo.removeLabel(null);
        return true;
    }

    @Override
    public Boolean caseForEachInStatement(ForEachInStatement node) {
        ForInFlowInfo forInfo = this.createForIn();
        this.setFlowInfo(node, forInfo);
        forInfo.mergeParameter(this.getFlowInfo(node.getItem()), this.fFlowContext);
        forInfo.mergeExpression(this.getFlowInfo(node.getCollection()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        forInfo.removeLabel(null);
        return true;
    }

    @Override
    public Boolean caseExpressionStatement(ExpressionStatement node) {
        this.assignFlowInfo(node, node.getExpression());
        return true;
    }

    @Override
    public Boolean casePropertyAccessExpression(PropertyAccessExpression node) {
        this.processSequential(node, node.getObject(), node.getProperty());
        return true;
    }

    @Override
    public Boolean caseSimplePropertyAssignment(SimplePropertyAssignment node) {
        this.processSequential((Node)node, node.getInitializer());
        return true;
    }

    @Override
    public Boolean caseForStatement(ForStatement node) {
        ForFlowInfo forInfo = this.createFor();
        this.setFlowInfo(node, forInfo);
        forInfo.mergeInitializer(this.getFlowInfo(node.getInitialization()), this.fFlowContext);
        forInfo.mergeCondition(this.getFlowInfo(node.getCondition()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        forInfo.mergeIncrement(this.createSequential(node.getIncrement()), this.fFlowContext);
        forInfo.removeLabel(null);
        return true;
    }

    @Override
    public Boolean caseIfStatement(IfStatement node) {
        IfFlowInfo info = this.createIf();
        this.setFlowInfo(node, info);
        info.mergeCondition(this.getFlowInfo(node.getPredicate()), this.fFlowContext);
        info.merge(this.getFlowInfo(node.getConsequent()), this.getFlowInfo(node.getAlternative()), this.fFlowContext);
        return true;
    }

    @Override
    public Boolean caseBinaryExpression(BinaryExpression node) {
        if (RefactoringUtils.isAssignment(node.getOperation())) {
            FlowInfo lhs = this.getFlowInfo(node.getLeft());
            FlowInfo rhs = this.getFlowInfo(node.getRight());
            if (lhs instanceof LocalFlowInfo) {
                LocalFlowInfo llhs = (LocalFlowInfo)lhs;
                llhs.setWriteAccess(this.fFlowContext);
                if (node.getOperation() != BinaryOperator.ASSIGN) {
                    GenericSequentialFlowInfo tmp = this.createSequential();
                    tmp.merge(new LocalFlowInfo(llhs, 2, this.fFlowContext), this.fFlowContext);
                    tmp.merge(rhs, this.fFlowContext);
                    rhs = tmp;
                }
            }
            GenericSequentialFlowInfo info = this.createSequential(node);
            info.merge(rhs, this.fFlowContext);
            info.merge(lhs, this.fFlowContext);
        } else {
            this.processSequential(node, node.getLeft(), node.getRight());
        }
        return true;
    }

    @Override
    public Boolean caseLabeledStatement(LabeledStatement node) {
        FlowInfo info = this.assignFlowInfo(node, node.getStatement());
        if (info != null) {
            info.removeLabel(node.getLabel());
        }
        return true;
    }

    @Override
    public Boolean caseFunctionExpression(FunctionExpression node) {
        GenericSequentialFlowInfo info = this.createSequential();
        GenericSequentialFlowInfo inner = this.processSequential((Node)node, (List<? extends Node>)node.getParameters());
        inner.merge(this.getFlowInfo(node.getBody()), this.fFlowContext);
        inner.setNoReturn();
        this.callInfo.merge(inner, this.fFlowContext);
        this.setFlowInfo(node, info);
        return true;
    }

    @Override
    public Boolean caseGetterAssignment(GetterAssignment node) {
        GenericSequentialFlowInfo info = this.processSequential((Node)node, node.getBody());
        info.setNoReturn();
        return true;
    }

    @Override
    public Boolean caseSetterAssignment(SetterAssignment node) {
        GenericSequentialFlowInfo info = this.processSequential((Node)node, node.getParameter());
        info.merge(this.getFlowInfo(node.getBody()), this.fFlowContext);
        info.setNoReturn();
        return true;
    }

    @Override
    public Boolean caseCallExpression(CallExpression node) {
        MessageSendFlowInfo info = this.createMessageSendFlowInfo();
        this.setFlowInfo(node, info);
        for (Expression arg : node.getArguments()) {
            info.mergeArgument(this.getFlowInfo(arg), this.fFlowContext);
        }
        info.mergeReceiver(this.getFlowInfo(node.getApplicant()), this.fFlowContext);
        this.closureInfo.assignAccessMode(this.callInfo);
        return true;
    }

    @Override
    public Boolean caseParenthesizedExpression(ParenthesizedExpression node) {
        this.assignFlowInfo(node, node.getEnclosed());
        return true;
    }

    @Override
    public Boolean caseUnaryExpression(UnaryExpression node) {
        if (RefactoringUtils.hasSideEffect(node.getOperation())) {
            FlowInfo info = this.getFlowInfo(node.getArgument());
            if (info instanceof LocalFlowInfo) {
                GenericSequentialFlowInfo result = this.createSequential(node);
                result.merge(info, this.fFlowContext);
                result.merge(new LocalFlowInfo((LocalFlowInfo)info, 8, this.fFlowContext), this.fFlowContext);
            } else {
                this.setFlowInfo(node, info);
            }
        } else {
            this.assignFlowInfo(node, node.getArgument());
        }
        return true;
    }

    @Override
    public Boolean caseReturnStatement(ReturnStatement node) {
        if (this.createReturnFlowInfo(node)) {
            ReturnFlowInfo info = this.createReturn(node);
            this.setFlowInfo(node, info);
            info.merge(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        } else {
            this.assignFlowInfo(node, node.getExpression());
        }
        return true;
    }

    @Override
    public Boolean caseVariableReference(VariableReference node) {
        VariableBinding binding = this.fFlowContext.resolve(node.getVariable());
        if (binding != null) {
            this.setFlowInfo(node, new LocalFlowInfo(binding, 2, this.fFlowContext));
        }
        return true;
    }

    @Override
    public Boolean caseSwitchStatement(SwitchStatement node) {
        this.caseSwitchStatement(node, this.createSwitchData(node));
        return true;
    }

    @Override
    public Boolean caseThrowStatement(ThrowStatement node) {
        ThrowFlowInfo info = this.createThrow();
        this.setFlowInfo(node, info);
        Expression expression = node.getException();
        info.merge(this.getFlowInfo(expression), this.fFlowContext);
        return true;
    }

    @Override
    public Boolean caseTryStatement(TryStatement node) {
        TryFlowInfo info = this.createTry();
        this.setFlowInfo(node, info);
        info.mergeTry(this.getFlowInfo(node.getBody()), this.fFlowContext);
        for (CatchClause element : node.getCatches()) {
            info.mergeCatch(this.getFlowInfo(element), this.fFlowContext);
        }
        info.mergeFinally(this.getFlowInfo(node.getFinallyClause()), this.fFlowContext);
        return true;
    }

    @Override
    public Boolean caseVariableStatement(VariableStatement node) {
        this.processSequential((Node)node, (List<? extends Node>)node.getDeclarations());
        return true;
    }

    @Override
    public Boolean caseConstStatement(ConstStatement node) {
        this.processSequential((Node)node, (List<? extends Node>)node.getDeclarations());
        return true;
    }

    @Override
    public Boolean caseVariableDeclaration(VariableDeclaration node) {
        VariableBinding binding = this.fFlowContext.resolve(node.getIdentifier());
        LocalFlowInfo nameInfo = null;
        Expression initializer = node.getInitializer();
        if (binding != null && initializer != null) {
            nameInfo = new LocalFlowInfo(binding, 8, this.fFlowContext);
        }
        GenericSequentialFlowInfo info = this.processSequential((Node)node, initializer);
        info.merge(nameInfo, this.fFlowContext);
        return true;
    }

    @Override
    public Boolean caseWhileStatement(WhileStatement node) {
        WhileFlowInfo info = this.createWhile();
        this.setFlowInfo(node, info);
        info.mergeCondition(this.getFlowInfo(node.getCondition()), this.fFlowContext);
        info.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        info.removeLabel(null);
        return true;
    }

    protected static class SwitchData {
        private boolean fHasDefaultCase;
        private List<IRegion> fRanges = new ArrayList<IRegion>(4);
        private List<FlowInfo> fInfos = new ArrayList<FlowInfo>(4);

        protected SwitchData() {
        }

        public void setHasDefaultCase() {
            this.fHasDefaultCase = true;
        }

        public boolean hasDefaultCase() {
            return this.fHasDefaultCase;
        }

        public void add(IRegion range, FlowInfo info) {
            this.fRanges.add(range);
            this.fInfos.add(info);
        }

        public IRegion[] getRanges() {
            return this.fRanges.toArray(new IRegion[this.fRanges.size()]);
        }

        public FlowInfo[] getInfos() {
            return this.fInfos.toArray(new FlowInfo[this.fInfos.size()]);
        }

        public FlowInfo getInfo(int index) {
            return this.fInfos.get(index);
        }
    }
}

