/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.typeinfo.IElementConverter;
import org.eclipse.dltk.javascript.typeinfo.IElementResolver;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceHandlerFactory;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeProvider;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.dltk.utils.SimpleExtensionManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class TypeInfoManager {
    private static final String EXT_POINT = "org.eclipse.dltk.javascript.core.typeinfo";
    private static final String MODEL_ELEMENT = "model";
    private static final String RESOURCE_ATTR = "resource";
    private static final String URI_ATTR = "uri";
    private static final String BUILDER_ELEMENT = "builder";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final String RESOLVER_ELEMENT = "resolver";
    private static final String CONVERTER_ELEMENT = "converter";
    private static final String EVALUATOR_ELEMENT = "evaluator";
    private static final String NODE_HANDLER_ELEMENT = "nodeHandler";
    private static final SimpleExtensionManager<IModelBuilder> modelBuilderManager = new SimpleExtensionManager<IModelBuilder>(IModelBuilder.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected IModelBuilder createInstance(IConfigurationElement element) {
            if (TypeInfoManager.BUILDER_ELEMENT.equals(element.getName())) {
                return (IModelBuilder)super.createInstance(element);
            }
            return null;
        }
    };
    private static final LazyExtensionManager<ITypeProvider> providerManager = new LazyExtensionManager<ITypeProvider>("org.eclipse.dltk.javascript.core.typeinfo"){

        protected boolean isValidElement(IConfigurationElement element) {
            return TypeInfoManager.PROVIDER_ELEMENT.equals(element.getName());
        }

        protected LazyExtensionManager.Descriptor<ITypeProvider> createDescriptor(IConfigurationElement element) {
            return new TypeProviderDescriptor(this, element);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TypeProviderDescriptor
        extends LazyExtensionManager.Descriptor<ITypeProvider> {
            public TypeProviderDescriptor(LazyExtensionManager<ITypeProvider> manager, IConfigurationElement configurationElement) {
                super(manager, configurationElement);
            }

            public ITypeProvider get() {
                return (ITypeProvider)this.create();
            }
        }
    };
    private static final SimpleExtensionManager<IElementResolver> resolverManager = new SimpleExtensionManager<IElementResolver>(IElementResolver.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected IElementResolver createInstance(IConfigurationElement element) {
            if (TypeInfoManager.RESOLVER_ELEMENT.equals(element.getName())) {
                return (IElementResolver)super.createInstance(element);
            }
            return null;
        }
    };
    private static final SimpleExtensionManager<IElementConverter> converterManager = new SimpleExtensionManager<IElementConverter>(IElementConverter.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected IElementConverter createInstance(IConfigurationElement element) {
            if (TypeInfoManager.CONVERTER_ELEMENT.equals(element.getName())) {
                return (IElementConverter)super.createInstance(element);
            }
            return null;
        }
    };
    private static final SimpleExtensionManager<IMemberEvaluator> evaluatorManager = new SimpleExtensionManager<IMemberEvaluator>(IMemberEvaluator.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected IMemberEvaluator createInstance(IConfigurationElement element) {
            if (TypeInfoManager.EVALUATOR_ELEMENT.equals(element.getName())) {
                return (IMemberEvaluator)super.createInstance(element);
            }
            return null;
        }
    };
    private static final SimpleExtensionManager<ITypeInferenceHandlerFactory> nodeHandlerManager = new SimpleExtensionManager<ITypeInferenceHandlerFactory>(ITypeInferenceHandlerFactory.class, "org.eclipse.dltk.javascript.core.typeinfo"){

        protected ITypeInferenceHandlerFactory createInstance(IConfigurationElement element) {
            if (TypeInfoManager.NODE_HANDLER_ELEMENT.equals(element.getName())) {
                return (ITypeInferenceHandlerFactory)super.createInstance(element);
            }
            return null;
        }
    };

    private static String trim(String str) {
        if (str != null && (str = str.trim()).length() == 0) {
            str = null;
        }
        return str;
    }

    private static URI createURI(IConfigurationElement element, String resource) {
        return URI.createPlatformPluginURI((String)("/" + element.getContributor().getName() + "/" + resource), (boolean)true);
    }

    private static IConfigurationElement[] getConfigurationElements() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_POINT);
    }

    public static IModelBuilder[] getModelBuilders(ITypeInfoContext context) {
        IModelBuilder[] all = (IModelBuilder[])modelBuilderManager.getInstances();
        if (context == null) {
            return all;
        }
        HashMap<String, ModelBuilderRec> recs = new HashMap<String, ModelBuilderRec>();
        IModelBuilder[] iModelBuilderArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder builder = iModelBuilderArray[n2];
            int priority = builder.priorityFor(context);
            if (priority != -1) {
                String featureId = builder.getFeatureId();
                ModelBuilderRec rec = (ModelBuilderRec)recs.get(featureId);
                if (rec != null) {
                    if (priority > rec.priority) {
                        rec.priority = priority;
                        rec.builder = builder;
                    }
                } else {
                    rec = new ModelBuilderRec();
                    rec.builder = builder;
                    rec.priority = priority;
                    recs.put(featureId, rec);
                }
            }
            ++n2;
        }
        IModelBuilder[] result = new IModelBuilder[recs.size()];
        int index = 0;
        for (ModelBuilderRec rec : recs.values()) {
            result[index++] = rec.builder;
        }
        return result;
    }

    public static ITypeProvider[] createTypeProviders(ITypeInfoContext context) {
        LazyExtensionManager.Descriptor[] descriptors = providerManager.getDescriptors();
        ITypeProvider[] providers = new ITypeProvider[descriptors.length];
        int index = 0;
        LazyExtensionManager.Descriptor[] descriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            LazyExtensionManager.Descriptor descriptor = descriptorArray[n2];
            ITypeProvider provider = (ITypeProvider)descriptor.get();
            if (provider != null && provider.initialize(context)) {
                providers[index++] = provider;
            }
            ++n2;
        }
        if (index != providers.length) {
            ITypeProvider[] result = new ITypeProvider[index];
            System.arraycopy(providers, 0, result, 0, index);
            return result;
        }
        return providers;
    }

    public static IElementResolver[] getElementResolvers() {
        return (IElementResolver[])resolverManager.getInstances();
    }

    public static IElementConverter[] getElementConverters() {
        return (IElementConverter[])converterManager.getInstances();
    }

    public static IMemberEvaluator[] getMemberEvaluators() {
        return (IMemberEvaluator[])evaluatorManager.getInstances();
    }

    public static ITypeInferenceHandlerFactory[] getNodeHandlerFactories() {
        return (ITypeInferenceHandlerFactory[])nodeHandlerManager.getInstances();
    }

    public static ResourceSet loadModelResources() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IConfigurationElement[] iConfigurationElementArray = TypeInfoManager.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (MODEL_ELEMENT.equals(element.getName())) {
                String resource = TypeInfoManager.trim(element.getAttribute(RESOURCE_ATTR));
                String uri = TypeInfoManager.trim(element.getAttribute(URI_ATTR));
                try {
                    if (uri != null) {
                        if (resource != null) {
                            resourceSet.getURIConverter().getURIMap().put(URI.createURI((String)uri), TypeInfoManager.createURI(element, resource));
                            resourceSet.getResources().add((Object)TypeInfoManager.createResource(URI.createURI((String)uri)));
                        }
                    } else if (resource != null) {
                        resourceSet.getResources().add((Object)TypeInfoManager.createResource(TypeInfoManager.createURI(element, resource)));
                    }
                }
                catch (IllegalArgumentException e) {
                    JavaScriptPlugin.error(e);
                }
            }
            ++n2;
        }
        for (Resource r : new ArrayList(resourceSet.getResources())) {
            if (r.isLoaded()) continue;
            try {
                r.load(null);
            }
            catch (IOException e) {
                JavaScriptPlugin.error("Error loading " + r.getURI(), e);
                if (r.isLoaded()) continue;
                r.getContents().clear();
            }
        }
        return resourceSet;
    }

    private static Resource createResource(URI uri) {
        return new XMIResourceImpl(uri);
    }

    static class ModelBuilderRec {
        IModelBuilder builder;
        int priority;

        ModelBuilderRec() {
        }
    }
}

